<?php

use App\Models\Setting;
use Illuminate\Support\Facades\Storage;
use GeoSot\EnvEditor\Facades\EnvEditor;


/**
 * calculateDue
 *
 * @param  mixed $total
 * @param  mixed $total_paid
 * @return void
 */
function calculateDue($total, $total_paid)
{
    if ($total > $total_paid) {
        return $total - $total_paid;
    } else {
        return 0;
    }
}

/**
 * currencySymbol
 *
 * @return void
 */
function currencySymbol()
{
    return (config('currency_symbol') ?? '$').' ';
}


// Make minimum 8 digits
/**
 * make8digits
 *
 * @param  mixed $num
 * @return void
 */
function make8digits($num)
{
    return sprintf("%08d", $num);
}

function make2digits($num)
{
    return sprintf("%02d", $num);
}


function make2decimal($number)
{
    return number_format((float)$number, 2, '.', '');
}

function commaSeparateObjectItem($object, $field)
{
    $total = count($object);
    $data_string = '';

    for ($i = 0; $i < $total; $i++) {
        $string = $data_string . $object[$i]->$field;
        if ($i < $total - 1) $string .= ', ';

        $data_string = $string;
    }
    return $data_string;
}
