<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Appointment;
use App\Models\AppointmentSection;
use App\Models\AppointmentStatus;
use App\Models\Customer;
use App\Models\PermissionToUser;
use App\Models\CustomerLinkPackage;
use App\Models\CooperationStore;
use App\Models\ItemStore;
use Illuminate\Support\Facades\DB;

class AppointmentController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('appointments', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $appointments = Appointment::with(['customer', 'packages'])->get();

        $sections = AppointmentSection::where('status', '1')->get();
        
        $customers = Customer::with(['packages'])->get();
        
        
        $statuses = AppointmentStatus::with(['detail'])->where('status', '1')->get();
        $store_all_array = CooperationStore::with(['company'])->where('status', '1')->get();
        
        $item_store_array = ItemStore::with(['item', 'store'])->get();

        return response()->json([
            'appointments'  => $appointments,
            'sections'      => $sections,
            'customers'     => $customers,
            'statuses'      => $statuses,
            'store_all_array'   => $store_all_array,
            'item_store_array'   => $item_store_array,
            'permission'   => $this->permission
        ]);
    }

    public function store(Request $request)
    {
        $section = AppointmentSection::where('id', $request->input('section_id'))->first();

        $data['title'] = $request->input('title'); // 1
        $data['description'] = $request->input('description'); // 2
        $data['date'] = $request->input('date'); // 3
        $data['appointment_section_id'] = $request->input('section_id'); // 4
        $data['start'] = $section->start; // 5
        $data['end'] = $section->end; // 6
        $data['status'] = $request->input('status'); // 7
        $data['customer_id'] = $request->input('customer_id'); // 8
        $data['customer_package_id'] = $request->input('package_id'); // 9
        $data['store_type'] = $request->input('store_type'); // 10
        $data['store_id'] = $request->input('store_id'); // 11

        $data['allday'] = false;

        Appointment::create($data);

        return response()->json([
            'success' => true,
            'data'      => $data,
            // 'user'      => session('user_id')
        ]);

    }

    public function edit(string $id)
    {
        $appointment = Appointment::where('id', $id)->first();

        return response()->json([
            'appointment' => $appointment,
        ]);
    }

    public function update(Request $request, string $id)
    {
        $appointment = Appointment::find($id);

        $section = AppointmentSection::where('id', $request->input('section_id'))->first();

        $data['title'] = $request->input('title'); // 1
        $data['description'] = $request->input('description'); // 2
        $data['date'] = $request->input('date'); // 3
        $data['appointment_section_id'] = $request->input('section_id'); // 4
        $data['start'] = $section->start; // 5
        $data['end'] = $section->end; // 6
        $data['status'] = $request->input('status'); // 7
        $data['customer_id'] = $request->input('customer_id'); // 8
        $data['customer_package_id'] = $request->input('package_id'); // 9
        $data['store_type'] = $request->input('store_type'); // 10
        $data['store_id'] = $request->input('store_id'); // 11

        $data['allday'] = false;

        $appointment->update($data);

        return response()->json([
            'success' => true,
            'data'      => $data,
            'user'      => session('user_id'),
            'id'        => $id
        ]);
    }


    public function destroy(string $id)
    {
        $response = Appointment::where('id', $id)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => 'Delete Successful!',
                'text'      => 'appointment has been Deleted!'
            ]);
        }

    }
}
