<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AppointmentSection;
use App\Models\PermissionToUser;
use App\Models\Language;

class AppointmentSectionController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('appointment_section', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('appointment_section_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['appointment_section_show'] = true;
        } else {
            $this->permission_type['appointment_section_show'] = false;
        }

        if (array_search('appointment_section_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['appointment_section_create'] = true;
        } else {
            $this->permission_type['appointment_section_create'] = false;
        }

        if (array_search('appointment_section_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['appointment_section_update'] = true;
        } else {
            $this->permission_type['appointment_section_update'] = false;
        }

        if (array_search('appointment_section_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['appointment_section_delete'] = true;
        } else {
            $this->permission_type['appointment_section_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $sections = AppointmentSection::orderBy('id', 'ASC')->get();

        $permission_type['appointment_section_show'] = $this->permission_type['appointment_section_show'];
        $permission_type['appointment_section_create'] = $this->permission_type['appointment_section_create'];
        $permission_type['appointment_section_update'] = $this->permission_type['appointment_section_update'];
        $permission_type['appointment_section_delete'] = $this->permission_type['appointment_section_delete'];

        return response()->json([
            'sections' => $sections,
            'permission'    => $this->permission,
            'permission_type' => $permission_type
        ]);
    }

    public function create()
    {
        $permission_type['appointment_section_create'] = $this->permission_type['appointment_section_create'];

        return response()->json([
            'permission_type' => $permission_type,
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['appointment_section_create'] != true) {
            return response()->json([
                'success' => false,
            ]);
        }
        $data['start'] = $request->input('start');
        $data['end'] = $request->input('end');
        $data['status'] = $request->input('status');
        $data['sort'] = $request->input('sort');

        AppointmentSection::create($data);

        return response()->json([
            'success' => true,
            'data'      => $data
        ]);

    }

    public function show(string $id)
    {
        $section = AppointmentSection::find($id);

        $permission_type['appointment_section_update'] = $this->permission_type['appointment_section_update'];

        return response()->json([
            'section' => $section,
            'permission_type' => $permission_type,
        ], 200);
        
    }

    public function edit(string $id)
    {
        $section = AppointmentSection::find($id);

        $permission_type['appointment_section_update'] = $this->permission_type['appointment_section_update'];

        return response()->json([
            'section' => $section,
            'permission_type' => $permission_type,
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['appointment_section_update'] != true) {
            return response()->json([
                'success' => false,
            ]);
        }

        $section = AppointmentSection::find($id);
        $data['start'] = $request->input('start');
        $data['end'] = $request->input('end');
        $data['sort'] = $request->input('sort');
        $data['status'] = $request->input('status');
        $section->update($data);

        return response()->json([
            'success' => true,
        ]);
        
        
    }

    public function destroy(string $id)
    {
        if($this->permission_type['appointment_section_delete'] == true) {

            $response = AppointmentSection::find($id)->delete();
            
            if($response) {
                return response()->json([
                    'response'  => $response,
                    'title'     => '刪除成功',
                    'text'      => '付款方法已刪除!'
                ]);
            }
        }
        return response()->json([
            'response'  => false,
            'title'     => '刪除失敗!',
            'text'      => ''
        ]);
    }
}
