<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AppointmentStatus;
use App\Models\AppointmentStatusDetail;
use App\Models\PermissionToUser;
use App\Models\Language;

class AppointmentStatusController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('appointment_status', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('appointment_status_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['appointment_status_show'] = true;
        } else {
            $this->permission_type['appointment_status_show'] = false;
        }

        if (array_search('appointment_status_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['appointment_status_create'] = true;
        } else {
            $this->permission_type['appointment_status_create'] = false;
        }

        if (array_search('appointment_status_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['appointment_status_update'] = true;
        } else {
            $this->permission_type['appointment_status_update'] = false;
        }

        if (array_search('appointment_status_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['appointment_status_delete'] = true;
        } else {
            $this->permission_type['appointment_status_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $statuses = AppointmentStatus::with(['detail'])->orderBy('id', 'ASC')->get();

        $permission_type['appointment_status_show'] = $this->permission_type['appointment_status_show'];
        $permission_type['appointment_status_create'] = $this->permission_type['appointment_status_create'];
        $permission_type['appointment_status_update'] = $this->permission_type['appointment_status_update'];
        $permission_type['appointment_status_delete'] = $this->permission_type['appointment_status_delete'];

        return response()->json([
            'statuses' => $statuses,
            'permission'    => $this->permission,
            'permission_type' => $permission_type
        ]);
    }

    public function create()
    {
        $permission_type['appointment_status_create'] = $this->permission_type['appointment_status_create'];

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'permission_type' => $permission_type,
            'languages'         => $languages,
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['appointment_status_create'] != true) {
            return response()->json([
                'success' => false,
            ]);
        }
        $data['status'] = $request->input('status');
        $data['sort'] = $request->input('sort');

        $status = AppointmentStatus::create($data);

        foreach(json_decode($request->input('details')) as $v) 
        {
            $data['appointment_status_id']    = $status->id;
            $data['language_locale']    = $v->language_locale;
            $data['title']    = $v->title;

            AppointmentStatusDetail::create($data);
        }

        return response()->json([
            'success' => true,
            'data'      => $data
        ]);

    }

    public function show(string $id)
    {
        $status = AppointmentStatus::find($id);
        $permission_type['appointment_status_show'] = $this->permission_type['appointment_status_show'];

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'status' => $status,
            'permission_type' => $permission_type,
            'languages'         => $languages,
        ], 200);
    }

    public function edit(string $id)
    {
        $status = AppointmentStatus::with(['details'])->find($id);

        $permission_type['appointment_status_update'] = $this->permission_type['appointment_status_update'];

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'status' => $status,
            'permission_type' => $permission_type,
            'languages'         => $languages,
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['appointment_status_update'] != true) {
            return response()->json([
                'success' => false,
            ]);
        }

        $status = AppointmentStatus::find($id);
        $data['sort'] = $request->input('sort');
        $data['status'] = $request->input('status');
        $status->update($data);

        AppointmentStatusDetail::where('appointment_status_id', $id)->delete();

        foreach(json_decode($request->input('details')) as $v) 
        {
            $data['appointment_status_id']    = $id;
            $data['language_locale']    = $v->language_locale;
            $data['title']    = $v->title;

            AppointmentStatusDetail::create($data);
        }

        return response()->json([
            'success' => true,
            'success_message'    => 'update success'
        ]);
        
        
    }

    public function destroy(string $id)
    {
        if($this->permission_type['appointment_status_delete'] == true) {

            $response = AppointmentStatus::find($id)->delete();
            AppointmentStatusDetail::where('appointment_status_id', $id)->delete();
            if($response) {
                return response()->json([
                    'response'  => $response,
                    'title'     => '刪除成功',
                    'text'      => '付款方法已刪除!'
                ]);
            }
        }
        return response()->json([
            'response'  => false,
            'title'     => '刪除失敗!',
            'text'      => ''
        ]);
    }
}
