<?php

namespace App\Http\Controllers\Admin\Branch;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CooperationStore;
use App\Models\BranchCategory;
use App\Models\PermissionToUser;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\App;
use Illuminate\Contracts\Database\Eloquent\Builder;


class CategoryController extends Controller
{

    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        app::setlocale(session('locale'));
        
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('branch_categories', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('branch_category_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_category_show'] = true;
        } else {
            $this->permission_type['branch_category_show'] = false;
        }

        if (array_search('branch_category_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_category_create'] = true;
        } else {
            $this->permission_type['branch_category_create'] = false;
        }

        if (array_search('branch_category_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_category_update'] = true;
        } else {
            $this->permission_type['branch_category_update'] = false;
        }

        if (array_search('branch_category_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_category_delete'] = true;
        } else {
            $this->permission_type['branch_category_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $permission_type['branch_category_show'] = $this->permission_type['branch_category_show'];
        $permission_type['branch_category_create'] = $this->permission_type['branch_category_create'];
        $permission_type['branch_category_update'] = $this->permission_type['branch_category_update'];
        $permission_type['branch_category_delete'] = $this->permission_type['branch_category_delete'];

        $branch_categories = BranchCategory::with(['store'])->where('status', '>', 0)->orderBy('id', 'ASC')->get();

        return response()->json([
            'branch_categories' => $branch_categories,
            'permission'    => $this->permission,
            'permission_type' => $permission_type,
        ]);
    }

    public function create()
    {
        $stores = CooperationStore::where('status', '1')->get();
        $permission_type['branch_category_create'] = $this->permission_type['branch_category_create'];

        return response()->json([
            'permission_type' => $permission_type,
            'stores'         => $stores,
            'locale'    => App::currentLocale(),
        ]);
    }

    public function store(Request $request)
    {
        $data['cooperation_store_id'] = $request->input('store_id');
        $data['title'] = $request->input('title');
        $data['sort'] = $request->input('sort');
        $data['status'] = $request->input('status');

        BranchCategory::create($data);

        return response()->json([
            'message' => 'success',
            'data'      => $data
        ]);
    }

    public function show(string $id)
    {
        
        $permission_type['branch_category_show'] = $this->permission_type['branch_category_show'];

        $stores = CooperationStore::where('status', '1')->get();
        
        $cateogory = BranchCategory::with(['store'])->where('id', $id)->first();
        
        return response()->json([
            'stores'         => $stores,
            'category'         => $cateogory,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function edit(string $id)
    {

        $permission_type['branch_category_update'] = $this->permission_type['branch_category_update'];

        $stores = CooperationStore::where('status', '1')->get();
        
        $cateogory = BranchCategory::with(['store'])->where('id', $id)->first();
        
        return response()->json([
            'stores'         => $stores,
            'category'         => $cateogory,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['branch_category_update']) {
            return response()->json(['message' => 'fail']);
        }

        $branch_category = BranchCategory::find($id);
        $data['cooperation_store_id'] = $request->input('store_id');
        $data['title'] = $request->input('title');
        $data['sort'] = $request->input('sort');
        $data['status'] = $request->input('status');

        $branch_category->update($data);

        return response()->json([
            'message' => 'success',
        ]);
    }

    public function destroy(string $id)
    {
        $response = BranchCategory::find($id)->delete();
       
        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

        return response()->json([
            'message'  => 'fail',
        ]);
    }
}
