<?php

namespace App\Http\Controllers\Admin\Branch;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CooperationStore;
use App\Models\BranchCustomer;
use App\Models\PermissionToUser;
use Illuminate\Support\Facades\App;
use Illuminate\Contracts\Database\Eloquent\Builder;


class CustomerController extends Controller
{

    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        app::setlocale(session('locale'));
        
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('branch_customers', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('branch_customer_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_customer_show'] = true;
        } else {
            $this->permission_type['branch_customer_show'] = false;
        }

        if (array_search('branch_customer_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_customer_create'] = true;
        } else {
            $this->permission_type['branch_customer_create'] = false;
        }

        if (array_search('branch_customer_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_customer_update'] = true;
        } else {
            $this->permission_type['branch_customer_update'] = false;
        }

        if (array_search('branch_customer_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_customer_delete'] = true;
        } else {
            $this->permission_type['branch_customer_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $permission_type['branch_customer_show'] = $this->permission_type['branch_customer_show'];
        $permission_type['branch_customer_create'] = $this->permission_type['branch_customer_create'];
        $permission_type['branch_customer_update'] = $this->permission_type['branch_customer_update'];
        $permission_type['branch_customer_delete'] = $this->permission_type['branch_customer_delete'];

        $branch_customers = BranchCustomer::with(['store'])->orderBy('id', 'ASC')->get();

        return response()->json([
            'branch_customers' => $branch_customers,
            'permission'    => $this->permission,
            'permission_type' => $permission_type,
        ]);
    }

    public function create()
    {
        $stores = CooperationStore::where('status', '1')->get();
        $permission_type['branch_customer_create'] = $this->permission_type['branch_customer_create'];

        return response()->json([
            'permission_type' => $permission_type,
            'stores'         => $stores,
            'locale'    => App::currentLocale(),
        ]);
    }

    public function store(Request $request)
    {
        $data['cooperation_store_id'] = $request->input('store_id');
        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email') ?? "";
        $data['country_code'] = $request->input('country_code');
        $data['telephone'] = $request->input('telephone');
        $data['status'] = $request->input('status');

        BranchCustomer::create($data);

        return response()->json([
            'message' => 'success',
            'data'      => $data
        ]);
    }

    public function show(string $id)
    {
        
        $permission_type['branch_customer_show'] = $this->permission_type['branch_customer_show'];

        $stores = CooperationStore::where('status', '1')->get();
        
        $customer = BranchCustomer::with(['store'])->where('id', $id)->first();
        
        return response()->json([
            'stores'         => $stores,
            'customer'         => $customer,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function edit(string $id)
    {

        $permission_type['branch_customer_update'] = $this->permission_type['branch_customer_update'];

        $stores = CooperationStore::where('status', '1')->get();
        
        $customer = BranchCustomer::with(['store'])->where('id', $id)->first();
        
        return response()->json([
            'stores'         => $stores,
            'customer'         => $customer,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        // if($this->permission_type['branch_customer_update'] == true) {
        //     return response()->json(['message' => 'fail']);
        // }

        $branch_customer = BranchCustomer::find($id);
        $data['cooperation_store_id'] = $request->input('store_id');
        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email') ?? "";
        $data['country_code'] = $request->input('country_code');
        $data['telephone'] = $request->input('telephone');
        $data['status'] = $request->input('status');

        $branch_customer->update($data);

        return response()->json([
            'message' => 'success',
        ]);
    }

    public function destroy(string $id)
    {
        $response = BranchCustomer::find($id)->delete();
       
        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

        return response()->json([
            'message'  => 'fail',
        ]);
    }
}
