<?php

namespace App\Http\Controllers\Admin\Branch;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CooperationStore;
use App\Models\BranchCategory;
use App\Models\BranchItem;
use App\Models\PermissionToUser;
use Illuminate\Support\Facades\App;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Storage;


class ItemController extends Controller
{

    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        app::setlocale(session('locale'));
        
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('branch_items', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('branch_item_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_item_show'] = true;
        } else {
            $this->permission_type['branch_item_show'] = false;
        }

        if (array_search('branch_item_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_item_create'] = true;
        } else {
            $this->permission_type['branch_item_create'] = false;
        }

        if (array_search('branch_item_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_item_update'] = true;
        } else {
            $this->permission_type['branch_item_update'] = false;
        }

        if (array_search('branch_item_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_item_delete'] = true;
        } else {
            $this->permission_type['branch_item_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $permission_type['branch_item_show'] = $this->permission_type['branch_item_show'];
        $permission_type['branch_item_create'] = $this->permission_type['branch_item_create'];
        $permission_type['branch_item_update'] = $this->permission_type['branch_item_update'];
        $permission_type['branch_item_delete'] = $this->permission_type['branch_item_delete'];

        $branch_items = BranchItem::with(['category', 'store'])->where('status', '>', 0)->orderBy('id', 'ASC')->get();

        return response()->json([
            'items' => $branch_items,
            'permission'    => $this->permission,
            'permission_type' => $permission_type,
        ]);
    }

    public function create()
    {
        $stores = CooperationStore::with(['categories'])->where('status', '1')->get();
        
        $permission_type['branch_item_create'] = $this->permission_type['branch_item_create'];

        return response()->json([
            'permission_type' => $permission_type,
            'stores'         => $stores,
            'locale'    => App::currentLocale(),
        ]);
    }

    public function store(Request $request)
    {
        
        $data['branch_category_id'] = $request->input('category_id');
        $data['cooperation_store_id'] = $request->input('store_id');
        $data['title'] = $request->input('title');
        $data['description'] = $request->input('description');
        $data['price'] = $request->input('price');
        $data['sort'] = $request->input('sort') ?? "";
        $data['status'] = $request->input('status');
        $data['type'] = $request->input('type');
        $data['image'] = '';
        
        $result = BranchItem::create($data);
        
        if($request->hasFile('image')) {
            $item = BranchItem::find($result->id);
            $image = $request->file('image');
            $image_name = time().'_'.$image->getClientOriginalName();
            $data['image'] = 'branch/catalog/item/'.$result->id.'/'.$image_name;
            $image->storeAs('branch/catalog/item/'.$result->id, $image_name, 'public');
            $item->update($data);
        }

        return response()->json([
            'message' => 'success',
            'data'      => $data
        ]);
    }

    public function show(string $id)
    {
        
        $permission_type['branch_item_show'] = $this->permission_type['branch_item_show'];

        $stores = CooperationStore::with(['categories'])->where('status', '1')->get();
        
        $item = BranchItem::with(['store'])->where('id', $id)->first();
        
        return response()->json([
            'stores'         => $stores,
            'item'         => $item,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function edit(string $id)
    {

        $permission_type['branch_item_update'] = $this->permission_type['branch_item_update'];

        $stores = CooperationStore::with(['categories'])->where('status', '1')->get();
        
        $item = BranchItem::with(['store'])->where('id', $id)->first();
        
        return response()->json([
            'stores'         => $stores,
            'item'         => $item,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        // if($this->permission_type['branch_item_update']) {
        //     return response()->json(['message' => 'fail']);
        // }
        
        // $item = BranchItem::where('id', $id)->first();
        
        // if($item != null) {
            $item = BranchItem::find($id);
            $data['branch_category_id'] = $request->input('category_id');
            $data['cooperation_store_id'] = $request->input('store_id');
            $data['title'] = $request->input('title');
            $data['description'] = $request->input('description');
            $data['price'] = $request->input('price');
            $data['sort'] = $request->input('sort') ?? "";
            $data['status'] = $request->input('status');
            $data['type'] = $request->input('type');
        
            if($request->hasFile('image')) {
                Storage::disk('public')->delete($item->image);
                $image = $request->file('image');
                $image_name = time().'_'.$image->getClientOriginalName();
                $data['image'] = 'branch/catalog/item/'.$id.'/'.$image_name;
                $image->storeAs('branch/catalog/item/'.$id, $image_name, 'public');
            }

            $result = $item->update($data);

            if($result) {
                return response()->json([
                    'message'   => 'success',
                ]);    
            }
        // }

        // return response()->json([
        //     'message' => 'fail',
        // ]);
    }

    public function destroy(string $id)
    {
        $response = BranchItem::find($id)->delete();
       
        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

        return response()->json([
            'message'  => 'fail',
        ]);
    }
}
