<?php

namespace App\Http\Controllers\Admin\Branch;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CooperationStore;
use App\Models\BranchItem;
use App\Models\BranchOrder;
use App\Models\BranchCustomer;
use App\Models\Customer;
use App\Models\PermissionToUser;
use App\Models\CustomerLinkPackage;
use App\Models\PaymentMethod;
use App\Models\OrderStatus;
use App\Models\BranchOrderTransaction;
use App\Models\BranchOrderItem;
use App\Models\CustomerPackage;
use Illuminate\Support\Facades\App;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Support\Facades\DB;


class OrderController extends Controller
{

    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        app::setlocale(session('locale'));
        
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('branch_orders', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('branch_order_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_order_show'] = true;
        } else {
            $this->permission_type['branch_order_show'] = false;
        }

        if (array_search('branch_order_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_order_create'] = true;
        } else {
            $this->permission_type['branch_order_create'] = false;
        }

        if (array_search('branch_order_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_order_update'] = true;
        } else {
            $this->permission_type['branch_order_update'] = false;
        }

        if (array_search('branch_order_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['branch_order_delete'] = true;
        } else {
            $this->permission_type['branch_order_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        
        $this->role_id = session('role_id');

    }
    
    public function branch_customer(Request $request)
    {
        $store_id = $request->input('store_id');
        
        $branch_customers = BranchCustomer::where('cooperation_store_id', $request->input('store_id'))->get();
        
        return response()->json([
            'branch_customers'     => $branch_customers,
        ]);
    }
    
    public function customer_packages(Request $request)
    {
        $customer_id = $request->input('customer_id');
        
        $customer_packages = CustomerLinkPackage::with(['package'])->where('customer_id', $customer_id)->get();
        
        return response()->json([
            'customer_packages'     => $customer_packages,
            'customer_id'           => $customer_id
        ]);

    }
    
    public function branch_items(Request $request)
    {
        $store_id = $request->input('store_id');
        
        $branch_items = BranchItem::where('status', "1")->get();
        
        return response()->json([
            'branch_items'     => $branch_items,
            'store_id'           => $store_id
        ]);

    }

    public function index()
    {
        $permission_type['branch_order_show'] = $this->permission_type['branch_order_show'];
        $permission_type['branch_order_create'] = $this->permission_type['branch_order_create'];
        $permission_type['branch_order_update'] = $this->permission_type['branch_order_update'];
        $permission_type['branch_order_delete'] = $this->permission_type['branch_order_delete'];

        $branch_orders = BranchOrder::with(['store', 'customer'])->orderBy('id', 'ASC')->get();

        return response()->json([
            'branch_orders' => $branch_orders,
            'permission'    => $this->permission,
            'permission_type' => $permission_type,
        ]);
    }

    public function create()
    {
        $stores = CooperationStore::where('status', '1')->get();
        
        $existing_customers = Customer::where('status', 1)->get();
        
        $permission_type['branch_order_create'] = $this->permission_type['branch_order_create'];
        
        $payment_methods = PaymentMethod::with(['detail'])->where('status', '1')->orderBy('sort', 'ASC')->get();
        
        $order_statuses = OrderStatus::with(['detail'])->where('status', 1)->orderBy('sort', 'ASC')->get();

        return response()->json([
            'permission_type' => $permission_type,
            'existing_customers' => $existing_customers,
            'stores'         => $stores,
            'payment_methods'   => $payment_methods,
            'order_statuses'    => $order_statuses
        ]);
    }

    public function store(Request $request)
    {
        $data['cooperation_store_id'] = $request->input('store_id');
        $data['order_date'] = $request->input('order_date');
        $data['customer_type'] = $request->input('customer_type');
        
        if($request->input('customer_type') == 'existing_customer') {
            $customer_id = $request->input('order_customer');
            
            $customer = Customer::where('id', $customer_id)->first();
            
            $data['customer_id'] = $customer_id;
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
        }
        
        if($request->input('customer_type') == 'branch_customer') {
            $customer_id = $request->input('order_branch_customer');
            
            $customer = BranchCustomer::where('id', $customer_id)->first();
            
            $data['customer_id'] = $customer_id;
            
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
        }
        
        if($request->input('customer_type') == 'custom_customer') {
            
            $customer = json_decode($request->input('order_custom_customer'));
            
            $branch_customer['cooperation_store_id'] = $request->input('store_id');
            $branch_customer['name'] = $customer->name;
            $branch_customer['telephone'] = $customer->telephone;
            $branch_customer['email'] = $customer->email;
            $branch_customer['country_code'] = $customer->country_code;
            $branch_customer['status'] = "1";
            
            $new_branch_customer = BranchCustomer::create($branch_customer);
            
            $data['customer_id'] = $new_branch_customer->id;
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
        }
        
        $data['comment'] = $request->input('comment') ?? "";
        
        $data['total'] = $request->input('grand_total');
        
        $data['status_id'] = $request->input('order_status_id');

        $status = OrderStatus::with(['detail'])->where('id', $request->input('order_status_id'))->first();
        
        $data['status'] = $status->detail->title ?? NULL;

        $branch_order = BranchOrder::create($data);

        $payment_method = PaymentMethod::with(['detail'])->where('id', $request->input('payment_method_id'))->first();

        $order_transaction['branch_order_id'] = $branch_order->id;
        $order_transaction['payment_method_id'] = $request->input('payment_method_id');
        $order_transaction['payment_option'] = $request->input('payment_option');
        $order_transaction['payment_method'] = $payment_method->detail->title;
        $order_transaction['payment_amount'] = $request->input('payment_amount');

        BranchOrderTransaction::create($order_transaction);

        $items = json_decode($request->input('order_items'));

        foreach($items as $item) {

            if($item->type == 'cash_coupon' || $item->type == 'service') 
            {
                $customer_package = DB::table('customer_packages')->where('id', $item->id)->first();
                
                $customer_package_update = CustomerPackage::find($item->id);
                
                $customer_package_update->time_used = $customer_package->time_used + 1;
                $customer_package_update->time_remain = $customer_package->time_remain - 1;
                
                $customer_package_update->save();
            }
            
            $order_item['branch_order_id'] = $branch_order->id;
            $order_item['item_id'] = "";    
            $order_item['customer_package_id'] = "";
            $order_item['branch_item_id'] = "";
            
            if($item->type == 'item') {
                $order_item['branch_item_id'] = $item->id;
            }
            
            if($item->type == 'cash_coupon' || $item->type == 'service') {
                $order_item['item_id'] = $item->id;    
                $order_item['customer_package_id'] = $item->id;
            }
            
            $order_item['title'] = $item->detail ?? $item->title;
            $order_item['quantity'] = $item->quantity;
            $order_item['unit_price'] = $item->unit_price;
            $order_item['item_type'] = $item->type;
            $order_item['total'] = $item->total;
            $order_item_result = BranchOrderItem::create($order_item);
        }
       

        return response()->json([
            'message' => 'success',
            'data'      => $data
        ]);
    }

    public function show(string $id)
    {
        $permission_type['branch_order_show'] = $this->permission_type['branch_order_show'];
        
        $stores = CooperationStore::where('status', '1')->get();
        
        $payment_methods = PaymentMethod::with(['detail'])->where('status', '1')->orderBy('sort', 'ASC')->get();
        
        $order = BranchOrder::with(['store', 'items', 'transactions', 'customer'])->where('id', $id)->first();
        
        $order_statuses = OrderStatus::with(['detail'])->where('status', 1)->orderBy('sort', 'ASC')->get();
        
        $existing_customers = Customer::where('status', 1)->get();

        return response()->json([
            'file_path'         => asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/'),
            'permission_type'       => $permission_type,
            'order'                 => $order,
            'stores'                => $stores,
            'payment_methods'       => $payment_methods,
            'existing_customers'    => $existing_customers,
            'order_statuses'        => $order_statuses
        ], 200);
    }

    public function edit(string $id)
    {
        $permission_type['branch_order_update'] = $this->permission_type['branch_order_update'];
        
        $stores = CooperationStore::where('status', '1')->get();
        
        $payment_methods = PaymentMethod::with(['detail'])->where('status', '1')->orderBy('sort', 'ASC')->get();
        
        $order = BranchOrder::with(['store', 'items', 'transactions', 'customer'])->where('id', $id)->first();
        
        $order_statuses = OrderStatus::with(['detail'])->where('status', 1)->orderBy('sort', 'ASC')->get();
        
        $existing_customers = Customer::where('status', 1)->get();

        return response()->json([
            'file_path'         => asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/'),
            'permission_type'       => $permission_type,
            'order'                 => $order,
            'stores'                => $stores,
            'payment_methods'       => $payment_methods,
            'existing_customers'    => $existing_customers,
            'order_statuses'        => $order_statuses
        ], 200);

    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['branch_order_update'] == false) {
            return response()->json(['message' => 'fail']);
        }
        
        $branch_order = BranchOrder::find($id);
        
        $data['cooperation_store_id'] = $request->input('store_id');
        $data['order_date'] = $request->input('order_date');
        $data['customer_type'] = $request->input('customer_type');
        
        if($request->input('customer_type') == 'existing_customer') {
            $customer_id = $request->input('order_customer');
            
            $customer = Customer::where('id', $customer_id)->first();
            
            $data['customer_id'] = $customer_id;
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
        }
        
        if($request->input('customer_type') == 'branch_customer') {
            $customer_id = $request->input('order_branch_customer');
            
            $customer = BranchCustomer::where('id', $customer_id)->first();
            
            $data['customer_id'] = $customer_id;
            
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
        }
        
        if($request->input('customer_type') == 'custom_customer') {
            
            $customer = json_decode($request->input('order_custom_customer'));
            
            $branch_customer['cooperation_store_id'] = $request->input('store_id');
            $branch_customer['name'] = $customer->name;
            $branch_customer['telephone'] = $customer->telephone;
            $branch_customer['email'] = $customer->email;
            $branch_customer['country_code'] = $customer->country_code;
            $branch_customer['status'] = "1";
            
            $new_branch_customer = BranchCustomer::create($branch_customer);
            
            $data['customer_id'] = $new_branch_customer->id;
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
        }
        
        $data['comment'] = $request->input('comment') ?? "";
        
        $data['total'] = $request->input('sub_total');
        
        $data['status_id'] = $request->input('order_status_id');

        $status = OrderStatus::with(['detail'])->where('id', $request->input('order_status_id'))->first();
        
        $data['status'] = $status->detail->title ?? NULL;

        $branch_order->update($data);
        
        if($request->input('payment_method_id') != null) {
            $payment_method = PaymentMethod::with(['detail'])->where('id', $request->input('payment_method_id'))->first();

            $order_transaction['branch_order_id'] = $id;
            $order_transaction['payment_method_id'] = $request->input('payment_method_id');
            $order_transaction['payment_option'] = $request->input('payment_option');
            $order_transaction['payment_method'] = $payment_method->detail->title;
            $order_transaction['payment_amount'] = $request->input('payment_amount');
            
            $order_transaction['receipt_image'] = "";
            if($request->hasFile('upload_receipt_image')) {
                $image = $request->file('upload_receipt_image');
                $order_transaction['receipt_image'] = 'branch/sale/transaction/'.time().'_'.$image->getClientOriginalName();
                $image->storeAs('', $order_transaction['receipt_image'], 'public');
            }
        
            $order_transaction['payment_image'] = "";
        
            if($request->hasFile('upload_payment_record_image')) {
                $image = $request->file('upload_payment_record_image');
                $order_transaction['payment_image'] = 'branch/sale/transaction/'.time().'_'.$image->getClientOriginalName();
                $image->storeAs('', $order_transaction['payment_image'], 'public');
            }

            BranchOrderTransaction::create($order_transaction);    
        }
        
        $previous_items = BranchOrderItem::where('branch_order_id', $id)->get();
        
        // Restore Package to customer
        
        foreach($previous_items as $item) {
            if($item->type == 'cash_coupon' || $item->type == 'service') {
                $customer_package = DB::table('customer_packages')->where('id', $item->id)->first();
                
                if($customer_package) {
                    $customer_package_update = CustomerPackage::find($item->id);
                
                    $customer_package_update->time_used = $customer_package->time_used - 1;
                    $customer_package_update->time_remain = $customer_package->time_remain + 1;
                
                    $customer_package_update->save();    
                }
                
            }    
        }
        
        BranchOrderItem::where('branch_order_id', $id)->delete();

        $items = json_decode($request->input('order_items'));

        foreach($items as $item) {

            if($item->type == 'cash_coupon' || $item->type == 'service') 
            {
                $customer_package = DB::table('customer_packages')->where('id', $item->id)->first();
                
                if($customer_package) {
                    $customer_package_update = CustomerPackage::find($item->id);
                
                    $customer_package_update->time_used = $customer_package->time_used + 1;
                    $customer_package_update->time_remain = $customer_package->time_remain - 1;
                
                    $customer_package_update->save();    
                }
                
            }
            
            $order_item['branch_order_id'] = $id;
            $order_item['item_id'] = "";    
            $order_item['customer_package_id'] = "";
            $order_item['branch_item_id'] = "";
            
            if($item->type == 'item') {
                $order_item['branch_item_id'] = $item->id;
            }
            
            if($item->type == 'cash_coupon' || $item->type == 'service') {
                $order_item['item_id'] = $item->id;    
                $order_item['customer_package_id'] = $item->id;
            }
            
            $order_item['title'] = $item->title;
            $order_item['quantity'] = $item->quantity;
            $order_item['unit_price'] = $item->unit_price;
            $order_item['item_type'] = $item->type;
            $order_item['total'] = $item->total;
            $order_item_result = BranchOrderItem::create($order_item);
        }

        return response()->json([
            'permission_type'   => $this->permission_type['branch_order_update'],
            'message' => 'success',
        ]);
    }

    public function destroy(string $id)
    {
        BranchOrderItem::where('branch_order_id', $id)->delete();
        BranchOrderTransaction::where('branch_order_id', $id)->delete();
        
        $response = BranchOrder::find($id)->delete();
       
        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

        return response()->json([
            'message'  => 'fail',
        ]);
    }
}
