<?php

namespace App\Http\Controllers\Admin\Catalog;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\CategoryDetail;
use App\Models\Language;
use App\Models\PermissionToUser;
use Illuminate\Support\Facades\App;
use Illuminate\Contracts\Database\Eloquent\Builder;


class CategoryController extends Controller
{

    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        app::setlocale(session('locale'));
        
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('categories', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('category_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['category_show'] = true;
        } else {
            $this->permission_type['category_show'] = false;
        }

        if (array_search('category_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['category_create'] = true;
        } else {
            $this->permission_type['category_create'] = false;
        }

        if (array_search('category_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['category_update'] = true;
        } else {
            $this->permission_type['category_update'] = false;
        }

        if (array_search('category_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['category_delete'] = true;
        } else {
            $this->permission_type['category_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $permission_type['category_show'] = $this->permission_type['category_show'];
        $permission_type['category_create'] = $this->permission_type['category_create'];
        $permission_type['category_update'] = $this->permission_type['category_update'];
        $permission_type['category_delete'] = $this->permission_type['category_delete'];

        $categories = Category::with(['detail' => function (Builder $query) {
            $query->where('language_locale', '=', session('locale'));
        }])->orderBy('id', 'ASC')->get();

        return response()->json([
            'categories' => $categories,
            'permission'    => $this->permission,
            'permission_type' => $permission_type,
            'locale'    => session('locale'),
        ]);
    }

    public function create()
    {
        $languages = Language::where('status', '1')->get();
        $permission_type['category_create'] = $this->permission_type['category_create'];

        return response()->json([
            'permission_type' => $permission_type,
            'languages'         => $languages,
            'locale'    => App::currentLocale(),
        ]);
    }

    public function store(Request $request)
    {

        $data['sort'] = $request->input('sort');
        $data['status'] = $request->input('status');

        $category = Category::create($data);

        foreach(json_decode($request->input('title')) as $v) {
            $data['category_id'] = $category->id;
            $data['language_locale'] = $v->language_locale;
            $data['language_id'] = $v->language_id;
            $data['title'] = $v->title;
            CategoryDetail::create($data);
        }

        return response()->json([
            'message' => 'success',
        ]);
    }

    public function show(string $id)
    {
        if($this->permission_type['category_show'] == true) {
            return response()->json(['success' => false]);
        }

        $category = Category::find($id);

        return response()->json([
            'category' => $category,
        ], 200);
    }

    public function edit(string $id)
    {

        $permission_type['category_update'] = $this->permission_type['category_update'];

        // $category = Category::find($id);
        $category = Category::with(['details'])->where('id', $id)->first();
        $languages = Language::where('status', '1')->get();
        return response()->json([
            'category'          => $category,
            'languages'         => $languages,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        // if($this->permission_type['category_update']) {
        //     return response()->json(['success' => false]);
        // }

        $category = Category::find($id);
        $data['sort'] = $request->input('sort');
        $data['status'] = $request->input('status');

        $category->update($data);

        $categoryDetail = CategoryDetail::where('category_id', $id);
        $categoryDetail->delete();

        foreach(json_decode($request->input('title')) as $v) {
            $data['category_id'] = $category->id;
            $data['language_locale'] = $v->language_locale;
            $data['title'] = $v->title;
            CategoryDetail::create($data);
        }

        return response()->json([
            'message' => 'success',
        ]);
    }

    public function destroy(string $id)
    {
        

        $response = Category::find($id)->delete();
        CategoryDetail::where('category_id', $id)->delete();

        if($response) {
            return response()->json([
                'message'  => 'success',
                'title'     => 'Delete Successful!',
                'text'      => 'Category has been Deleted!'
            ]);
        }

        return response()->json([
            'message'  => 'fail',
        ]);
    }
}
