<?php

namespace App\Http\Controllers\Admin\Catalog;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Item;
use App\Models\ItemDetail;
use App\Models\ItemOverrideCommission;
use App\Models\ItemStore;
use App\Models\Category;
use App\Models\CategoryDetail;
use App\Models\PermissionToUser;
use App\Models\CooperationStore;
use App\Models\Language;
use Illuminate\Support\Facades\Hash;
use Illuminate\Contracts\Database\Eloquent\Builder;

class ItemController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('items', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('item_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['item_show'] = true;
        } else {
            $this->permission_type['item_show'] = false;
        }

        if (array_search('item_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['item_create'] = true;
        } else {
            $this->permission_type['item_create'] = false;
        }

        if (array_search('item_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['item_update'] = true;
        } else {
            $this->permission_type['item_update'] = false;
        }

        if (array_search('item_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['item_delete'] = true;
        } else {
            $this->permission_type['item_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $permission_type['item_show'] = $this->permission_type['item_show'];
        $permission_type['item_create'] = $this->permission_type['item_create'];
        $permission_type['item_update'] = $this->permission_type['item_update'];
        $permission_type['item_delete'] = $this->permission_type['item_delete'];
        
        $items = Item::with([
            'category' => function (Builder $query) {
                $query->where('language_locale', '=', session('locale'));
            },
            'detail'  => function (Builder $query) {
                $query->where('language_locale', '=', session('locale'));
            }
        ])->get();

        return response()->json([
            'items'         => $items,
            'permission'    => $this->permission,
            'permission_type' => $permission_type,
            'locale'        => session('locale')
        ]);
    }

    public function create()
    {
        $permission_type['item_create'] = $this->permission_type['item_create'];
        
        $category_array = Category::with(['detail' => function (Builder $query) {
            $query->where('language_locale', session('locale'));
        }])
        ->where('status', '1')->get();
        
        // $category_array = Category::with(['detail'])->where('status', '1')->get();

        $languages = Language::where('status', '1')->orderBy('default_language', 'desc')->get();
        
        $store_array = CooperationStore::with(['company'])->where('status', '1')->get();

        return response()->json([
            'category_array'            => $category_array,
            'store_array'           => $store_array,
            'permission_type'       => $permission_type,
            'languages'             => $languages
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['item_create'] != true) {
            return response()->json(['success' => false]);
        }
        
        $data['category_id'] = $request->input('category_id');
        $data['price'] = $request->input('price');
        $data['type'] = $request->input('type');
        $data['sort'] = $request->input('sort');
        $data['status'] = $request->input('status');
        
        $data['store_type'] = $request->input('store_type');

        $item = Item::create($data);

        foreach(json_decode($request->input('details')) as $v) {
            $data['item_id']            = $item->id;
            $data['title']              = $v->title ?? "";
            $data['description']        = $v->description ?? "";
            $data['language_locale']    = $v->language_locale;
            $data['language_id']        = $v->language_id;
            
            ItemDetail::create($data);
        }
        
        if($request->input('store_type') == 'custom') {
            foreach(json_decode($request->input('stores')) as $v) {
                $data['item_id']            = $item->id;
                $data['store_id']              = $v;
                ItemStore::create($data);
            }    
        }
        
        if($request->input('commission_override') == 'yes') {
            $data['item_id']            = $item->id;
            $data['value']            = 'yes';
            ItemOverrideCommission::create($data);
        }
        
        return response()->json([
            'message' => 'success',
            'data'      => $data
        ]);

    }


    public function show(string $id)
    {
        $permission_type['item_show'] = $this->permission_type['item_show'];
        $item = Item::find($id);
        $categories = Category::where('status', '1')->get();

        return response()->json([
            'item'              => $item,
            'categories'    => $categories,
            'permission_type'   => $permission_type
        ]);
    }

    public function edit(string $id)
    {
        $permission_type['item_update'] = $this->permission_type['item_update'];

        $category_array = Category::with(['detail'])->where('status', '1')->get();

        $languages = Language::where('status', '1')->orderBy('default_language', 'desc')->get();

        $item = Item::with(['details', 'stores', 'override_commission'])->where('id',$id)->first();
        
        $store_array = CooperationStore::with(['company'])->where('status', '1')->get();

        return response()->json([
            'item' => $item,
            'category_array'    => $category_array,
            'permission_type'   => $permission_type,
            'store_array'           => $store_array,
            'languages' => $languages,
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        // if($this->permission_type['item_update'] != true) {
        //     return response()->json(['success' => false]);
        // }
        $item = Item::find($id);
        $data['category_id'] = $request->input('category_id');
        $data['price'] = $request->input('price');
        $data['type'] = $request->input('type');
        $data['status'] = $request->input('status');
        $data['sort'] = $request->input('sort');
        $data['store_type'] = $request->input('store_type');
        $item->update($data);

        ItemDetail::where('item_id', $id)->delete();

        foreach(json_decode($request->input('details')) as $v) {
            $data['item_id']            = $id;
            $data['title']              = $v->title ?? "";
            $data['description']        = $v->description ?? "";
            $data['language_locale']    = $v->language_locale;
            $data['language_id']        = $v->language_id;
            
            ItemDetail::create($data);
        }
        
        if($request->input('store_type') == 'custom') {
            
            ItemStore::where('item_id', $id)->delete();
            
            foreach(json_decode($request->input('stores')) as $v) {
                $data['item_id']            = $id;
                $data['store_id']           = $v;
                ItemStore::create($data);
            }    
        }
        
        ItemOverrideCommission::where('item_id', $id)->delete();
        
        if($request->input('commission_override') == 'yes') {
            $data['item_id']            = $id;
            $data['value']            = 'yes';
            ItemOverrideCommission::create($data);
        }

        return response()->json([
            'message' => 'success',
            // 'id'        => $id,
            // 'data'      => $data,
            // 'success_message'    => 'update success'
        ]);

    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        
        if($this->permission_type['item_delete'] != true) {
            return response()->json(['success' => false]);
        }
        
        ItemDetail::where('item_id', $id)->delete();
        ItemStore::where('item_id', $id)->delete();
        ItemOverrideCommission::where('item_id', $id)->delete();

        $response = Item::find($id)->delete();

        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

        return response()->json([
            'response'  => false,
        ]);
    }
}
