<?php

namespace App\Http\Controllers\Admin\Catalog;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Package;
use App\Models\PackageDetail;
use App\Models\PackageItemDetail;
use App\Models\Item;
use App\Models\PackageItem;
use App\Models\PermissionToUser;
use App\Models\Language;
use Illuminate\Contracts\Database\Eloquent\Builder;

class PackageController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('packages', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('package_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['package_show'] = true;
        } else {
            $this->permission_type['package_show'] = false;
        }

        if (array_search('package_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['package_create'] = true;
        } else {
            $this->permission_type['package_create'] = false;
        }

        if (array_search('package_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['package_update'] = true;
        } else {
            $this->permission_type['package_update'] = false;
        }

        if (array_search('package_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['package_delete'] = true;
        } else {
            $this->permission_type['package_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $packages = Package::with(['detail'])->get();

        $permission_type['package_show'] = $this->permission_type['package_show'];
        $permission_type['package_create'] = $this->permission_type['package_create'];
        $permission_type['package_update'] = $this->permission_type['package_update'];
        $permission_type['package_delete'] = $this->permission_type['package_delete'];

        return response()->json([
            'packages'       => $packages,
            'permission'        => $this->permission,
            'permission_type'   => $permission_type  
        ]);
    }

    public function create()
    {
        $languages = Language::where('status', '1')->get();

        $items = Item::with('detail')->where('status', '1')->get();

        $permission_type['package_create'] = $this->permission_type['package_create'];

        return response()->json([
            'items' => $items,
            'permission_type' => $permission_type,
            'languages'    => $languages,
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['package_create'] != true) {
            return response()->json(['success' => false]);
        }

        // $data['title'] = $request->input('title');
        // $data['description'] = $request->input('description');
        $data['price'] = $request->input('price');
        $data['sort'] = $request->input('sort');
        if($request->input('status') > 0) {
            $data['status'] = 1;
        } else {
            $data['status'] = 0;
        }

        $package = Package::create($data);

        foreach(json_decode($request->input('details')) as $v) {
            $data['package_id'] = $package->id;
            $data['language_id'] = $v->language_id;
            $data['language_locale'] = $v->language_locale;
            $data['title'] = $v->title;
            $data['description'] = $v->description;
            PackageDetail::create($data);
        }

        if($request->input('package_items') != null) {

            $items = json_decode($request->input('package_items'));

            foreach($items as $item) {
                $data['item_id'] = null;

                $data['package_id'] = $package->id;

                if($item->type == 'item') {
                    $data['item_id'] = $item->title->id;
                }

                $data['times'] = $item->times;
                $data['duration'] = $item->duration;
                $data['type'] = $item->type;
                $package_item = PackageItem::create($data);

                if($item->type == 'text') {
                    foreach($item->details as $v) {
                        $data['package_id'] = $package->id;
                        $data['package_item_id'] = $package_item->id;
                        $data['title']  = $v->title;
                        $data['language_locale']  = $v->language_locale;
                        PackageItemDetail::create($data);
                    }
                }
            }
        }

        return response()->json([
            'message' => 'success',
            'data'      => $data
        ]);

    }

    public function show(string $id)
    {
        $package = Package::where('id',$id)->first();
        $package_items = PackageItem::where('package_id', $id)->get();
        $items = Item::all();
        $permission_type['package_show'] = $this->permission_type['package_show'];

        return response()->json([
            'items' => $items,
            'package' => $package,
            'package_items'  => $package_items,
            'permission_type' => $permission_type
        ], 200);
    }

    public function edit(string $id)
    {
        $languages = Language::where('status', '1')->get();

        $package = Package::with(['details'])->where('id',$id)->first();

        $package_items = PackageItem::with(['item', 'details'])->where('package_id', $id)->get();
        $items = Item::with('detail')->where('status', 1)->get();
        $permission_type['package_update'] = $this->permission_type['package_update'];

        return response()->json([
            'languages' => $languages,
            'items' => $items,
            'package' => $package,
            'package_items'  => $package_items,
            'permission_type' => $permission_type
        ], 200);

    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['package_update'] != true) {
            return response()->json(['success' => false]);
        }

        $Package = Package::find($id);
        // $data['title'] = $request->input('title');
        // $data['description'] = $request->input('description');
        $data['price'] = $request->input('price');
        $data['sort'] = $request->input('sort');
        if($request->input('status') > 0) {
            $data['status'] = 1;
        } else {
            $data['status'] = 0;
        }
        $Package->update($data);

        PackageDetail::where('package_id', $id)->delete();
        PackageItem::where('package_id', $id)->delete();
        PackageItemDetail::where('package_id', $id)->delete();

        foreach(json_decode($request->input('details')) as $v) {
            $data['package_id'] = $id;
            $data['language_id'] = $v->language_id;
            $data['language_locale'] = $v->language_locale;
            $data['title'] = $v->title;
            $data['description'] = $v->description;
            PackageDetail::create($data);
        }
        
        if($request->input('package_items') != null) {

            $items = json_decode($request->input('package_items'));

            foreach($items as $item) {
                $data['item_id'] = null;

                $data['package_id'] = $id;

                if($item->type == 'item') {
                    $data['item_id'] = $item->id;
                }

                $data['times'] = $item->times;
                $data['duration'] = $item->duration;
                $data['type'] = $item->type;
                $package_item = PackageItem::create($data);

                if($item->type == 'text') {
                    foreach($item->details as $v) {
                        $data['package_id'] = $id;
                        $data['package_item_id'] = $package_item->id;
                        $data['title']  = $v->title;
                        $data['language_locale']  = $v->language_locale;
                        PackageItemDetail::create($data);
                    }
                }
            }
        }

        return response()->json([
            'message' => 'success',
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        PackageDetail::where('package_id', $id)->delete();
        PackageItem::where('package_id', $id)->delete();
        PackageItemDetail::where('package_id', $id)->delete();
        $response = Package::where('id', $id)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => '刪除成功!',
                'text'      => '事項刪除成功!'
            ]);
        }

        return response()->json([
            'response'  => false,
            'title'     => '刪除失敗!',
            'text'      => ''
        ]);
    }
}
