<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CooperationCompany;
use App\Models\PermissionToUser;
use Illuminate\Support\Facades\App;
use Illuminate\Contracts\Database\Eloquent\Builder;


class CompanyController extends Controller
{

    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        app::setlocale(session('locale'));
        
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('cooperation_companies', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('cooperation_company_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['company_show'] = true;
        } else {
            $this->permission_type['company_show'] = false;
        }

        if (array_search('cooperation_company_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['company_create'] = true;
        } else {
            $this->permission_type['company_create'] = false;
        }

        if (array_search('cooperation_company_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['company_update'] = true;
        } else {
            $this->permission_type['company_update'] = false;
        }

        if (array_search('cooperation_company_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['company_delete'] = true;
        } else {
            $this->permission_type['company_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $permission_type['company_show'] = $this->permission_type['company_show'];
        $permission_type['company_create'] = $this->permission_type['company_create'];
        $permission_type['company_update'] = $this->permission_type['company_update'];
        $permission_type['company_delete'] = $this->permission_type['company_delete'];

        $companies = CooperationCompany::all();

        return response()->json([
            'companies' => $companies,
            'permission'    => $this->permission,
            'permission_type' => $permission_type,
            'locale'    => session('locale'),
        ]);
    }

    public function create()
    {
        
        $permission_type['company_create'] = $this->permission_type['company_create'];

        return response()->json([
            'permission_type' => $permission_type,
            'locale'    => App::currentLocale(),
        ]);
    }

    public function store(Request $request)
    {
        $data['name'] = $request->input('name');
        $data['contact_person'] = $request->input('contact_person');
        $data['telephone'] = $request->input('telephone');
        $data['status'] = $request->input('status');

        $result = CooperationCompany::create($data);

        return response()->json([
            'success' => true,
            'data'      => $result
        ]);
    }

    public function show(string $id)
    {
        $permission_type['company_show'] = $this->permission_type['company_show'];

        $company = CooperationCompany::find($id);

        return response()->json([
            'company' => $company,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function edit(string $id)
    {
        $permission_type['company_update'] = $this->permission_type['company_update'];

        $company = CooperationCompany::where('id', $id)->first();
        
        return response()->json([
            'company'          => $company,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['company_update'] != true) {
            return response()->json(['status' => false]);
        }

        $company = CooperationCompany::find($id);
        $data['name'] = $request->input('name');
        $data['contact_person'] = $request->input('contact_person');
        $data['telephone'] = $request->input('telephone');
        $data['status'] = $request->input('status');

        $company->update($data);

        return response()->json([
            'status' => true,
            'message'    => 'success',
        ]);
    }

    public function destroy(string $id)
    {
        
        $response = CooperationCompany::find($id)->delete();

        if($response) {
            return response()->json([
                'status'  => true,
                'message'     => 'success',
            ]);
        }

        return response()->json([
            'status'  => false,
            'message'     => 'fail'
        ]);
    }
}
