<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Appointment;
use App\Models\AppointmentSection;
use App\Models\AppointmentStatus;
use Illuminate\Http\Request;
use App\Models\Language;
use App\Models\Customer;
use App\Models\CustomerEmail;
use App\Models\CustomerEmailAttachment;
use App\Models\CustomerAddress;
use App\Models\CustomerLinkPackage;
use App\Models\CustomerPackage;
use App\Models\Order;
use App\Models\OrderCustomer;
use App\Models\PermissionToUser;
use App\Models\Setting;
use App\Models\CooperationStore;
use App\Models\ItemStore;
use App\Models\HrUser;
use App\Models\HrCustomerLink;
use Illuminate\Contracts\Session\Session;
use Illuminate\Support\Facades\Hash;
use \Firebase\JWT\JWT;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Mail;
use App\Mail\CustomerMail;


class CustomerController extends Controller
{

    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('customers', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('customer_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['customer_show'] = true;
        } else {
            $this->permission_type['customer_show'] = false;
        }

        if (array_search('customer_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['customer_create'] = true;
        } else {
            $this->permission_type['customer_create'] = false;
        }

        if (array_search('customer_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['customer_update'] = true;
        } else {
            $this->permission_type['customer_update'] = false;
        }

        if (array_search('customer_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['customer_delete'] = true;
        } else {
            $this->permission_type['customer_delete'] = false;
        }

        if (array_search('customer_email', array_column($permission_type, 'permission'))) {
            $this->permission_type['customer_email'] = true;
        } else {
            $this->permission_type['customer_email'] = false;
        }
        
        if (array_search('customer_agency', array_column($permission_type, 'permission'))) {
            $this->permission_type['customer_agency'] = true;
        } else {
            $this->permission_type['customer_agency'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }

        $this->role_id = session('role_id');

    }

    public function check_telephone(Request $request)
    {
        $telephone = $request->input('telephone');
        $current = $request->input('current');

        $customer = Customer::where('telephone', '=', $telephone);

        if($current) {
            $customer = Customer::where('telephone', '=', $telephone)
                    ->where('telephone', '!=', $current);
        }

        if($customer->exists()) {
            return response()->json([
                'telephone'     => $telephone,
                'message'   => 'Customer telephone exist'
            ]);
        }

    }

    public function check_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $customer = Customer::where('email', '=', $email);

        if($current) {
            $customer = Customer::where('email', '=', $email)
                    ->where('email', '!=', $current);
        }

        if($customer->exists()) {
            return response()->json([
                'email'     => $email,
                'current'   => $current,
                'message'   => 'Customer email exist'
            ]);
        }

    }

    public function index()
    {
        $customers = Customer::orderBy('id', 'ASC')->get();
        $permission_type['customer_show']   = $this->permission_type['customer_show'];
        $permission_type['customer_create'] = $this->permission_type['customer_create'];
        $permission_type['customer_update'] = $this->permission_type['customer_update'];
        $permission_type['customer_delete'] = $this->permission_type['customer_delete'];
        $permission_type['customer_email'] = $this->permission_type['customer_email'];
        $permission_type['customer_agency'] = $this->permission_type['customer_agency'];
        
        $hr_users = HrUser::where('status', '1')->get();

        return response()->json([
            'customers'         => $customers,
            'session'           => session('permission'),
            'permission'        => $this->permission,
            'permission_type'   => $this->permission_type,
            'hr_users'          => $hr_users
        ]);
    }

    public function create()
    {
        $languages = Language::where('status', 1)->get();
        return response()->json([
            'languages'         => $languages,
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['customer_create'] != true) {
            return response()->json([
                'success' => false,
            ]);    
        }

        $data['company'] = $request->input('company');
        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email');
        $data['wechat'] = $request->input('wechat');
        $data['country_code'] = $request->input('country_code');
        $data['telephone'] = $request->input('telephone');
        $data['password'] = Hash::make($request->input('password'));
        $data['language_id'] = $request->input('language_id');
        $data['status'] = $request->input('status');
        $customer = Customer::where('email', '=', $data['email']);
        if($customer->exists()) {
            return response()->json([
                'success'   => false,
                'message'   => 'Customer email exist'
            ]);
        }
        $customer = Customer::create($data);
        if($request->input('addresses') != null) {
            $addresses = json_decode($request->input('addresses'));

            foreach($addresses as $address) {
                $data['customer_id'] = $customer->id;
                $data['add_1'] = $address->add_1;
                $data['add_2'] = $address->add_2;
                $data['region'] = $address->region;
                $data['country'] = $address->country;
                CustomerAddress::create($data);
            }
        }

        return response()->json([
            'success' => true,
            'data'      => $data
        ]);
    }

    public function show(string $id)
    {

    }

    public function edit(string $id)
    {

        if($this->permission_type['customer_update'] != true || $this->permission_type['customer_show'] != true) {
            return response()->json([
                'success'   => false,
            ], 200);
        }
        
        $languages = Language::where('status', 1)->get();

        $customer = Customer::with(['packages'])->where('id', $id)->first();
        $addresses = CustomerAddress::where('customer_id',$id)->get();
        $orders = OrderCustomer::with(['orders'])->where('customer_id', $id)->get();
        $packages = CustomerLinkPackage::with(['customer_package', 'appointments'])->where('customer_id', $id)->get();
        $appointments = Appointment::where('customer_id', $id)->get();
        $sections = AppointmentSection::where('status', 1)->get();
        $status = AppointmentStatus::with(['detail'])->where('status', 1)->get();
        $store_all_array = CooperationStore::with(['company'])->where('status', '1')->get();
        $item_store_array = ItemStore::with(['item', 'store'])->get();

        $permission_type['customer_show'] = $this->permission_type['customer_show'];
        $permission_type['customer_update'] = $this->permission_type['customer_update'];

        return response()->json([
            'languages'    => $languages,
            'customer'      => $customer,
            'addresses'     => $addresses,
            'orders'        => $orders,
            'packages'      => $packages,
            'sections'      => $sections,
            'status'        => $status,
            'appointments'  => $appointments,
            'permission_type' => $permission_type,
            'store_all_array'   => $store_all_array,
            'item_store_array'   => $item_store_array,
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['customer_update'] == true) {
            $customer = Customer::where('email', '=', $request->input('email'))->where('id', '!=', $id);

            if($customer->exists()) {
                return response()->json([
                    'success'   => false,
                    'customer_message'   => 'Customer email exist'
                ]);
            }

            $customer = Customer::find($id);
            $data['company'] = $request->input('company');
            $data['name'] = $request->input('name');
            $data['email'] = $request->input('email');
            $data['wechat'] = $request->input('wechat');
            $data['country_code'] = $request->input('country_code');
            $data['telephone'] = $request->input('telephone');

            if($request->input('password')) {
                $customer->password = Hash::make($request->input('password'));
                $data['password'] = Hash::make($request->input('password'));
            }

            $data['language_id'] = $request->input('language_id');
            $data['status'] = $request->input('status');

            $customer->update($data);

            CustomerAddress::where('customer_id', $id)->delete();

            if($request->input('addresses') != null) {
                $addresses = json_decode($request->input('addresses'));

                foreach($addresses as $address) {
                    $data['customer_id'] = $customer->id;
                    $data['add_1'] = $address->add_1;
                    $data['add_2'] = $address->add_2;
                    $data['region'] = $address->region;
                    $data['country'] = $address->country;
                    CustomerAddress::create($data);
                }
            }

            return response()->json([
                'success' => true,
                'address' => $request->input('addresses'),
                'success_message'    => 'update success'
            ]);
        }
    }

    public function destroy(string $id)
    {
        if($this->permission_type['customer_update'] == true) {
            CustomerAddress::where('customer_id', $id)->delete();

            $response = Customer::find($id)->delete();

            if($response) {
                return response()->json([
                    'response'  => $response,
                    'title'     => 'Delete Successful!',
                    'text'      => 'Customer has been Deleted!'
                ]);
            }

            return response()->json([
                'response'  => false,
                'title'     => 'Delete Unsuccessful!',
                'text'      => ''
            ]);
        }
    }
    
    public function hr_user(Request $request)
    {
        // $data['hr_user_id'] = $request->input('hr_user_id');
        // $data['customer_id'] = $request->input('customer_id');
        
        HrCustomerLink::updateOrCreate(
            ['customer_id' => $request->input('customer_id')],
            ['hr_user_id' => $request->input('hr_user_id'), 'user_id' => session('user_id')]
        );
        
        return response()->json([
            'message'   => 'success',
        ], 200);
    }

    public function email_send(Request $request, string $id)
    {
        $data['title'] = $request->input('title');
        $data['content'] = $request->input('content');

        $data['attachments'] = null;
        
        $customer = Customer::where('id', $id)->first();

        $email = CustomerEmail::create($data);

        if($request->hasFile('attachments')) {
            $data['attachments'] = [];
            foreach($request->file('attachments') as $attachment) {
                
                $name = time().'_'.$attachment->getClientOriginalName();
                
                $path = $attachment->move(public_path('customers/emails/'.$email->id), $name);

                $file['name'] = $name;
                $file['customer_email_id'] = $email->id;
                $file['path'] = $path;
                CustomerEmailAttachment::create($file);
                
                array_push($data['attachments'], $path);

            }
        }

        Config::set('mail.default', Setting::where('key', 'MAIL_MAILER')->first()->value);
        Config::set('mail.mailers.smtp.transport', Setting::where('key', 'MAIL_MAILER')->first()->value);
        // Config::set('mail.mailers.smtp.url', Setting::where('key', 'MAIL_URL')->first()->value);    
        Config::set('mail.mailers.smtp.host', Setting::where('key', 'MAIL_HOST')->first()->value);
        Config::set('mail.mailers.smtp.port', Setting::where('key', 'MAIL_PORT')->first()->value);    
        Config::set('mail.mailers.smtp.encryption', Setting::where('key', 'MAIL_ENCRYPTION')->first()->value);
        Config::set('mail.mailers.smtp.username', Setting::where('key', 'MAIL_USERNAME')->first()->value);
        Config::set('mail.mailers.smtp.password', Setting::where('key', 'MAIL_PASSWORD')->first()->value);
        Config::set('mail.from.address', Setting::where('key', 'MAIL_FROM_ADDRESS')->first()->value);
        Config::set('mail.from.name', Setting::where('key', 'MAIL_FROM_NAME')->first()->value);

        Mail::to($customer->email)->send(new CustomerMail($data));

        return response()->json([
            'success' => true,
            'data'  => $data
        ]);
    }

}
