<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Customer;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use App\Models\Order;

class DashboardController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $customer_total = Customer::count();
        $orders = Order::all();
        $order_total = Order::where('total', '>', 0)->sum('total');
        $monthly_total = Order::where('order_date', 'LIKE', date("Y-m"))->sum('total');

        return response()->json([
            'customer_total'    => $customer_total,
            'total_orders'    => $orders->count(),
            'order_total'       => $order_total,
            'monthly_total'     => $monthly_total,
            'user_email' => session()->get('user_email'),
            'user_id'   => session()->get('user_id'),
            'session_id' => session('session_id')
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
