<?php

namespace App\Http\Controllers\Admin\Hr\Commissions;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrReferal;
use App\Models\HrUser;
use App\Models\PermissionToUser;
use App\Models\Language;
use Illuminate\Support\Facades\DB;

class ReferalController extends Controller
{
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('hr_referals', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('hr_referal_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_referal_create'] = true;
        } else {
            $this->permission_type['hr_referal_create'] = false;
        }

        if (array_search('hr_referal_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_referal_delete'] = true;
        } else {
            $this->permission_type['hr_referal_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index(Request $request)
    {
        $hr_user = "all";
        
        if($request->input('hr_user') == 'all') {
            $hr_user = "all";
        } else {
            $hr_user = $request->input('hr_user') ?? "all";
        }
        
        $year = date("Y");
        $month = date("m");
        
        if($request->input('year') == 'all') {
            $year = "";
        } else {
            $year = $request->input('year') ?? date("Y");
        }
        
        if($request->input('month') == 'all') {
            $month = "";
        } else {
            $month = $request->input('month') ?? date("m");
        }
        
        $order_date = $year.'-'.$month;
        
        
        $referals = HrReferal::with(['order', 'hr_user'])
                        ->where('order_date', 'like', '%'.$order_date.'%')
                        ->when($hr_user, function($query, string $hr_user) {
                            if($hr_user == "all") {
                                return $query->whereNotNull('hr_user_id');
                            } else {
                                return $query->where('hr_user_id', $hr_user);    
                            }
                        })
                        ->get();
                        
        $years = DB::table('hr_referals')
                        ->select(DB::raw('SUBSTRING(order_date, 1, 4) as year'))
                        ->groupBy('year')
                        ->get();
        
        $hr_users = HrUser::where('status', 1)->get();

        $permission_type['hr_referal_create'] = $this->permission_type['hr_referal_create'];
        $permission_type['hr_referal_delete'] = $this->permission_type['hr_referal_delete'];

        return response()->json([
            'referals'            => $referals,
            'hr_users'          => $hr_users,
            'permission'        => $this->permission,
            'permission_type'   => $permission_type,
            'years'         => $years,
            'year'          => $year,
            'month'         => $month,
            'hr_user'       => $hr_user
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['hr_referal_create'] != true) {
            return response()->json([
                'message' => 'fail',
            ]);
        }
        
        $data['order_id'] = $request->input('order_id');
        $data['hr_user_id'] = $request->input('hr_user_id');

        HrOrderLink::create($data);

        return response()->json([
            'message' => 'success',
        ]);

    }

    public function destroy(string $id)
    {
        if($this->permission_type['hr_referal_delete'] == true) {

            $response = HrOrderLink::find($id)->delete();
            
            if($response) {
                return response()->json([
                    'message'  => 'success'
                ]);
            }
        }
        return response()->json([
            'message'  => 'fail'
        ]);
    }
}
