<?php

namespace App\Http\Controllers\Admin\Hr\Commissions;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use App\Models\HrCommissionUser;
use App\Models\HrUser;

class UserController extends Controller
{
    public function index()
    {
        $commissions = HrCommissionUser::with(['hr_user', 'branch_order'])->orderBy('id', 'desc')->get();

        return response()->json([
            'commissions'  => $commissions,
        ]);
    }
    
    public function create()
    {
        $hr_users = HrUser::where('status', 1)->get();
        
        return response()->json([
            'hr_users'  => $hr_users,
            // 'customer_links'            => $customer_links,
            // 'store_all_array'           => $store_all_array,
            // 'sections'                  => $sections,
            // 'statuses'                  => $statuses,
        ]);
    }

    public function store(Request $request)
    {
        // $section = AppointmentSection::where('id', $request->input('appointment_section_id'))->first();
        // $customer_package = CustomerPackage::where('id', $request->input('customer_package_id'))->first();

        // $data['customer_type'] = $request->input('customer_type');
        
        // if($request->input('customer_type') == 'existing_customer') {
        //     $appointment_customer = HrAppointmentCustomer::where('id', $request->input('hr_appointment_customer_id'))->where('hr_user_id', session('hr_user_id'))->first();
        // }
        
        // $data['date'] = $request->input('appointment_date');
        // $data['customer_package_id'] = $request->input('customer_package_id');
        // $data['title']  = $customer_package->title;
        // $data['store_id'] = $request->input('branch_id');
        // $data['start'] = $section->start;
        // $data['end'] = $section->end;
        // $data['status'] = $request->input('status');
        // $data['customer_id'] = $request->input('customer_id');
        // $data['description'] = $request->input('description');
        // $data['appointment_section_id'] = $request->input('appointment_section_id');

        // $data['allday'] = false;

        // $appointment = Appointment::create($data);
        
        // $appointment_data['hr_appointment_customer_id'] = $request->input('hr_appointment_customer_id') ?? null;
        
        // if($request->input('customer_type') == 'custom_customer') {
            
        //     $customer = json_decode($request->input('appointment_custom_customer'));
            
        //     $customer_data['hr_user_id'] = session('hr_user_id');
        //     $customer_data['name'] = $customer->name;
        //     $customer_data['telephone'] = $customer->telephone;
        //     $customer_data['email'] = $customer->email;
        //     $customer_data['country_code'] = $customer->country_code;
        //     $customer_data['status'] = 1;
            
        //     $hr_appointment_customer = HrAppointmentCustomer::create($customer_data);
        //     $appointment_data['hr_appointment_customer_id'] = $hr_appointment_customer->id;
        // }
        
        // $appointment_data['appointment_id'] = $appointment->id;
        // $appointment_data['hr_user_id'] = session('hr_user_id');
        
        // HrAppointmentLink::create($appointment_data);

        return response()->json([
            'message' => 'success',
            // 'data'      => $data,
        ]);

    }

    public function edit(string $id)
    {
        $appointment = HrAppointmentLink::with(['appointment'])->where('appointment_id', $id)->where('hr_user_id', session('hr_user_id'))->first();
        
        $hr_appointment_customers = HrAppointmentCustomer::where('hr_user_id', session('hr_user_id'))->get();
        
        $customer_links = HrCustomerLink::with(['customer.packages'])->get();
        
        $store_all_array = CooperationStore::with(['company'])->where('status', '1')->get();
        
        $statuses = AppointmentStatus::with(['detail'])->where('status', '1')->get(); // all
        
        $sections = AppointmentSection::where('status', '1')->get();
        
        return response()->json([
            'hr_appointment_customers'  => $hr_appointment_customers,
            'customer_links'            => $customer_links,
            'store_all_array'           => $store_all_array,
            'sections'                  => $sections,
            'statuses'                  => $statuses,
            'appointment' => $appointment,
        ]);

    }

    public function update(Request $request, string $id)
    {
        $section = AppointmentSection::where('id', $request->input('appointment_section_id'))->first();
        $customer_package = CustomerPackage::where('id', $request->input('customer_package_id'))->first();

        $data['customer_type'] = $request->input('customer_type');
        
        if($request->input('customer_type') == 'existing_customer') {
            $appointment_customer = HrAppointmentCustomer::where('id', $request->input('hr_appointment_customer_id'))->where('hr_user_id', session('hr_user_id'))->first();
        }
        
        $data['date'] = $request->input('appointment_date'); //
        $data['customer_package_id'] = $request->input('customer_package_id'); //
        $data['title']  = $customer_package->title; //
        $data['store_id'] = $request->input('branch_id'); //
        $data['start'] = $section->start; //
        $data['end'] = $section->end; //
        $data['status'] = $request->input('status'); //
        $data['customer_id'] = $request->input('customer_id'); //
        $data['description'] = $request->input('description'); //
        $data['appointment_section_id'] = $request->input('appointment_section_id'); //
        $data['allday'] = false; //
        
        $appointment = Appointment::find($id);

        $appointment->update($data);
        
        HrAppointmentLink::where('appointment_id', $id)->delete();
        
        $appointment_data['hr_appointment_customer_id'] = $request->input('hr_appointment_customer_id') ?? null;
        
        if($request->input('customer_type') == 'custom_customer') {
            
            $customer = json_decode($request->input('appointment_custom_customer'));
            
            $customer_data['hr_user_id'] = session('hr_user_id');
            $customer_data['name'] = $customer->name;
            $customer_data['telephone'] = $customer->telephone;
            $customer_data['email'] = $customer->email;
            $customer_data['country_code'] = $customer->country_code;
            $customer_data['status'] = 1;
            
            $hr_appointment_customer = HrAppointmentCustomer::create($customer_data);
            $appointment_data['hr_appointment_customer_id'] = $hr_appointment_customer->id;
        }
        
        $appointment_data['appointment_id'] = $appointment->id;
        $appointment_data['hr_user_id'] = session('hr_user_id');
        
        HrAppointmentLink::create($appointment_data);

        return response()->json([
            'message'   => 'success',
        ]);
    }


    public function destroy(string $id)
    {
        $response = Appointment::where('id', $id)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => 'Delete Successful!',
                'text'      => 'appointment has been Deleted!'
            ]);
        }

    }

}
