<?php

namespace App\Http\Controllers\Admin\Hr;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrOther;
use App\Models\PermissionToUser;
use App\Models\Language;

class OtherCommissionController extends Controller
{
    public $hr_role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('hr_roles', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('hr_role_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_role_update'] = true;
        } else {
            $this->permission_type['hr_role_update'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $commissions = HrOther::where('type', 'commission')->get();

        return response()->json([
            'commissions' => $commissions
        ]);
    }


    public function update(Request $request)
    {
        // if($this->permission_type['hr_role_update'] != true) {
        //     return response()->json([
        //         'message' => 'fail',
        //     ]);
        // }
        
        HrOther::where('type', 'commission')->delete();
        
        $requests = $request->all();

        $data['type'] = 'commission';

        foreach ($requests as $key => $value) {
            $data['key'] = $key;
            $data['value'] = $value;
            HrOther::create($data);
        }
        
        // if($request->input('hr_user_commission_rate')) {
        //     $data['key'] = 'hr_user_commission_rate';
        //     $data['value'] = $request->input('hr_user_commission_rate');
        //     HrOther::create($data);
        // }
        
        // if($request->input('hr_user_commission_level')) {
        //     $data['key'] = 'hr_user_commission_level';
        //     $data['value'] = $request->input('hr_user_commission_level');
        //     HrOther::create($data);
        // }

        // if($request->input('team_result_rate')) {
        //     $data['key'] = 'team_result_rate';
        //     $data['value'] = $request->input('team_result_rate');
        //     HrOther::create($data);
        // }
        
        // if($request->input('team_total_result_level')) {
        //     $data['key'] = 'team_total_result_level';
        //     $data['value'] = $request->input('team_total_result_level');
        //     HrOther::create($data);
        // }
        

        return response()->json([
            'message' => 'success',
        ]);
        
        
    }

}
