<?php

namespace App\Http\Controllers\Admin\Hr;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use Illuminate\Support\Facades\DB;
use App\Models\HrCommissionUser;
use App\Models\HrCommissionTeam;
use App\Models\HrUser;

class ReportController extends Controller
{
    
    
    public function users(Request $request)
    {
        
        $hr_user = "all";
        
        if($request->input('hr_user') == 'all') {
            $hr_user = "all";
        } else {
            $hr_user = $request->input('hr_user') ?? "all";
        }
        
        $year = date("Y");
        $month = date("m");
        
        if($request->input('year') == 'all') {
            $year = "";
        } else {
            $year = $request->input('year') ?? date("Y");
        }
        
        if($request->input('month') == 'all') {
            $month = "";
        } else {
            $month = $request->input('month') ?? date("m");
        }
        
        $order_date = $year.'-'.$month;
        
        $commissions = HrCommissionUser::with(['hr_user'])
                            ->select(
                                'hr_user_id',
                                DB::raw("count(id) as total"),
                                DB::raw("DATE_FORMAT(order_date, '%Y-%m') new_date"),
                                DB::raw("ROUND(SUM(payable_amount), 2) as amount")
                            )
                            ->where('order_date', 'like', '%'.$order_date.'%')
                            ->when($hr_user, function($query, string $hr_user) {
                                if($hr_user == "all") {
                                    return $query->whereNotNull('hr_user_id');
                                } else {
                                    return $query->where('hr_user_id', $hr_user);    
                                }
                                
                                
                            })
                            // ->when($hr_user != "all", function($query, string $hr_user) {
                            //     return $query->where('hr_user_id', $hr_user);
                            // })
                            
                            ->groupby('hr_user_id', 'new_date')
                            ->get();
                            
        $years = DB::table('hr_commission_users')
                        ->select(DB::raw('SUBSTRING(order_date, 1, 4) as year'))
                        ->groupBy('year')
                        ->get();
        
        $hr_users = HrUser::where('status', 1)->get();

        return response()->json([
            'commissions'   => $commissions,
            'years'         => $years,
            'hr_users'      => $hr_users,
            'year'          => $year,
            'month'         => $month,
            'hr_user'       => $hr_user
        ]);
    }
    
    public function superiors(Request $request)
    {
        $hr_user = "all";
        
        if($request->input('hr_user') == 'all') {
            $hr_user = "all";
        } else {
            $hr_user = $request->input('hr_user') ?? "all";
        }
        
        $year = date("Y");
        $month = date("m");
        
        if($request->input('year') == 'all') {
            $year = "";
        } else {
            $year = $request->input('year') ?? date("Y");
        }
        
        if($request->input('month') == 'all') {
            $month = "";
        } else {
            $month = $request->input('month') ?? date("m");
        }
        
        $order_date = $year.'-'.$month;
        
        $commissions = HrCommissionTeam::with(['hr_user'])
                            ->select(
                                'hr_user_id',
                                DB::raw("count(id) as total"),
                                DB::raw("DATE_FORMAT(order_date, '%Y-%m') new_date"),
                                DB::raw("ROUND(SUM(payable_amount), 2) as amount")
                            )
                            ->where('order_date', 'like', '%'.$order_date.'%')
                            ->when($hr_user, function($query, string $hr_user) {
                                if($hr_user == "all") {
                                    return $query->whereNotNull('hr_user_id');
                                } else {
                                    return $query->where('hr_user_id', $hr_user);    
                                }
                            })
                            ->groupby('hr_user_id', 'new_date')
                            ->get();
                            
        $years = DB::table('hr_commission_teams')
                        ->select(DB::raw('SUBSTRING(order_date, 1, 4) as year'))
                        ->groupBy('year')
                        ->get();
        
        $hr_users = HrUser::where('status', 1)->get();

        return response()->json([
            'commissions'   => $commissions,
            'years'         => $years,
            'hr_users'      => $hr_users,
            'year'          => $year,
            'month'         => $month,
            'hr_user'       => $hr_user
        ]);
    }
    
    public function teams(Request $request)
    {
        
    }
    
    public function rewards(Request $request)
    {
        
    }
}
