<?php

namespace App\Http\Controllers\Admin\Hr;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrRole;
use App\Models\Language;
use App\Models\HrPermission;
use App\Models\PermissionToUser;
use App\Models\HrPermissionToUser;

class RoleController extends Controller
{
    public $hr_role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('hr_roles', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('hr_role_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_role_show'] = true;
        } else {
            $this->permission_type['hr_role_show'] = false;
        }

        if (array_search('hr_role_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_role_create'] = true;
        } else {
            $this->permission_type['hr_role_create'] = false;
        }

        if (array_search('hr_role_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_role_update'] = true;
        } else {
            $this->permission_type['hr_role_update'] = false;
        }

        if (array_search('hr_role_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_role_delete'] = true;
        } else {
            $this->permission_type['hr_role_delete'] = false;
        }

        // if(!session('hr_role_id')) {
        //     return redirect()->route('login');
        // }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $roles = HrRole::orderBy('id', 'ASC')->get();

        $permission_type['hr_role_show'] = $this->permission_type['hr_role_show'];
        $permission_type['hr_role_create'] = $this->permission_type['hr_role_create'];
        $permission_type['hr_role_update'] = $this->permission_type['hr_role_update'];
        $permission_type['hr_role_delete'] = $this->permission_type['hr_role_delete'];

        return response()->json([
            'roles' => $roles,
            'permission'    => $this->permission,
            'permission_type' => $permission_type
        ]);
    }

    public function create()
    {
        $permission_type['hr_role_create'] = $this->permission_type['hr_role_create'];
        
        $roles = HrRole::where('status', 1)->get();
        
        $permissions = HrPermission::with('children')
                        ->where('parent_id', '=', null)
                        ->orderBy('sort', 'asc')->get();

        return response()->json([
            'permissions'  => $permissions,
            'permission_type' => $permission_type,
            'roles'             => $roles
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['hr_role_create'] != true) {
            return response()->json([
                'message' => 'fail',
            ]);
        }
        
        $data['default'] = false;
        $data['title'] = $request->input('title');
        $data['parent_id'] = $request->input('parent') ?? "";
        $data['status'] = $request->input('status');
        
        $role = HrRole::where('title', '=', $request->input('title'));

        if($role->exists()) {
            return response()->json([
                'success'   => 'fail',
            ]);
        }
        
        if($request->input('default') == 'true') {
            HrRole::where('default', true)->update(['default' => false]);
            $data['default'] = true;    
        }

        HrRole::create($data);
        
        $permissions = json_decode($request->input('permissions'));
        
        foreach($permissions as $permission) {
            $data['hr_role_id'] = $role->first()->id ?? 0;
            $data['permission'] = $permission;
            HrPermissionToUser::create($data);
        }

        return response()->json([
            'data'      => $data,
            'message' => 'success',
        ]);

    }

    public function show(string $id)
    {
        $section = HrRole::find($id);

        $permission_type['hr_role_update'] = $this->permission_type['hr_role_update'];

        return response()->json([
            'section' => $section,
            'permission_type' => $permission_type,
        ], 200);
        
    }

    public function edit(string $id)
    {
        $permission_type['hr_role_update'] = $this->permission_type['hr_role_update'];
        
        $role = HrRole::find($id);

        $roles = HrRole::where('id', '!=', $id)->where('status', 1)->get();
        
        $hr_permissions = HrPermission::with('children')
                        ->where('parent_id', '=', null)
                        ->orderBy('id', 'asc')->get();
                        
        $hr_permission_to_users = HrPermissionToUser::where('hr_role_id', '=', $id)->get();

        return response()->json([
            'role'      => $role,
            'roles'     => $roles,
            'permission_type' => $permission_type,
            'hr_permissions' => $hr_permissions,
            'hr_permission_to_users'   => $hr_permission_to_users,
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['hr_role_update'] != true) {
            return response()->json([
                'message' => 'fail',
            ]);
        }

        $section = HrRole::find($id);
        $data['title'] = $request->input('title');
        $data['parent_id'] = $request->input('parent');
        $data['status'] = $request->input('status');
        $data['default'] = false;
        
        if($request->input('default') == 'true') {
            HrRole::where('default', true)->update(['default' => false]);
            $data['default'] = true;    
        }
        
        $section->update($data);
        
        HrPermissionToUser::where('hr_role_id', $id)->delete();
        
        $permissions = json_decode($request->input('permissions'));
        
        foreach($permissions as $permission) {
            $data['hr_role_id'] = $id ?? 0;
            $data['permission'] = $permission;
            HrPermissionToUser::create($data);
        }

        return response()->json([
            'message' => 'success',
        ]);
        
        
    }

    public function destroy(string $id)
    {
        if($this->permission_type['hr_role_delete'] == true) {

            HrPermissionToUser::where('hr_role_id', $id)->delete();
            
            $response = HrRole::find($id)->delete();
            
            if($response) {
                return response()->json([
                    'message'  => 'success'
                ]);
            }
        }
        return response()->json([
            'message'  => 'fail'
        ]);
    }
}
