<?php

namespace App\Http\Controllers\Admin\Hr\Sales;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrBranchOrderLink;
use App\Models\PermissionToUser;
use App\Models\Language;
use App\Models\HrUser;

class BranchOrderController extends Controller
{
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('hr_sales_branch_orders', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('hr_sales_branch_order_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_sales_branch_order_show'] = true;
        } else {
            $this->permission_type['hr_sales_branch_order_show'] = false;
        }

        if (array_search('hr_sales_branch_order_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_sales_branch_order_create'] = true;
        } else {
            $this->permission_type['hr_sales_branch_order_create'] = false;
        }

        if (array_search('hr_sales_branch_order_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_sales_branch_order_update'] = true;
        } else {
            $this->permission_type['hr_sales_branch_order_update'] = false;
        }

        if (array_search('hr_sales_branch_order_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_sales_branch_order_delete'] = true;
        } else {
            $this->permission_type['hr_sales_branch_order_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        
        $this->role_id = session('role_id');

    }

    public function index()
    {

        $branch_orders = HrBranchOrderLink::with(['hr_user'])->get();
        
        $hr_users = HrUser::where('status', 1)->get();

        $permission_type['hr_sales_branch_order_show'] = $this->permission_type['hr_sales_branch_order_show'];
        $permission_type['hr_sales_branch_order_create'] = $this->permission_type['hr_sales_branch_order_create'];
        $permission_type['hr_sales_branch_order_update'] = $this->permission_type['hr_sales_branch_order_update'];
        $permission_type['hr_sales_branch_order_delete'] = $this->permission_type['hr_sales_branch_order_delete'];

        return response()->json([
            'branch_orders'     => $branch_orders,
            'hr_users'          => $hr_users,
            'permission'        => $this->permission,
            'permission_type'   => $permission_type
        ]);
    }


    public function store(Request $request)
    {
        if($this->permission_type['hr_sales_branch_order_create'] != true) {
            return response()->json([
                'message' => 'fail',
            ]);
        }
        
        $data['hr_branch_order_id'] = $request->input('title');
        $data['appointment_id'] = $request->input('appointment_id');
        $data['hr_user_id'] = $request->input('hr_user_id');

        HrBranchOrderLink::create($data);

        return response()->json([
            'message' => 'success',
        ]);

    }


    public function destroy(string $id)
    {
        if($this->permission_type['hr_sales_branch_order_delete'] == true) {

            $response = HrBranchOrderLink::find($id)->delete();
            
            if($response) {
                return response()->json([
                    'message'  => 'success'
                ]);
            }
        }
        return response()->json([
            'message'  => 'fail'
        ]);
    }
}
