<?php

namespace App\Http\Controllers\Admin\Hr\Sales;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrOrderLink;
use App\Models\HrUser;
use App\Models\PermissionToUser;
use App\Models\Language;

class OrderController extends Controller
{
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('hr_sales_orders', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('hr_sales_order_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_sales_order_show'] = true;
        } else {
            $this->permission_type['hr_sales_order_show'] = false;
        }

        if (array_search('hr_sales_order_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_sales_order_create'] = true;
        } else {
            $this->permission_type['hr_sales_order_create'] = false;
        }

        if (array_search('hr_sales_order_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_sales_order_update'] = true;
        } else {
            $this->permission_type['hr_sales_order_update'] = false;
        }

        if (array_search('hr_sales_order_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_sales_order_delete'] = true;
        } else {
            $this->permission_type['hr_sales_order_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $orders = HrOrderLink::with(['hr_user', 'order'])->get();
        
        $hr_users = HrUser::where('status', 1)->get();

        $permission_type['hr_sales_order_show'] = $this->permission_type['hr_sales_order_show'];
        $permission_type['hr_sales_order_create'] = $this->permission_type['hr_sales_order_create'];
        $permission_type['hr_sales_order_update'] = $this->permission_type['hr_sales_order_update'];
        $permission_type['hr_sales_order_delete'] = $this->permission_type['hr_sales_order_delete'];

        return response()->json([
            'orders'            => $orders,
            'hr_users'          => $hr_users,
            'permission'        => $this->permission,
            'permission_type'   => $permission_type
        ]);
    }

    public function create()
    {
        $permission_type['hr_sales_order_create'] = $this->permission_type['hr_sales_order_create'];
        
        $roles = HrRole::where('status', 1)->get();

        return response()->json([
            'permission_type' => $permission_type,
            'roles'             => $roles
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['hr_sales_order_create'] != true) {
            return response()->json([
                'message' => 'fail',
            ]);
        }
        
        $data['order_id'] = $request->input('order_id');
        $data['hr_user_id'] = $request->input('hr_user_id');

        HrOrderLink::create($data);

        return response()->json([
            'message' => 'success',
        ]);

    }

    public function show(string $id)
    {
        $section = HrRole::find($id);

        $permission_type['hr_sales_order_update'] = $this->permission_type['hr_sales_order_update'];

        return response()->json([
            'section' => $section,
            'permission_type' => $permission_type,
        ], 200);
        
    }

    public function edit(string $id)
    {
        $permission_type['hr_sales_order_update'] = $this->permission_type['hr_sales_order_update'];
        
        $role = HrRole::find($id);

        $roles = HrRole::where('id', '!=', $id)->where('status', 1)->get();

        return response()->json([
            'role'      => $role,
            'roles'     => $roles,
            'permission_type' => $permission_type,
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['hr_sales_order_update'] != true) {
            return response()->json([
                'message' => 'fail',
            ]);
        }

        $section = HrRole::find($id);
        $data['title'] = $request->input('title');
        $data['parent_id'] = $request->input('parent');
        $data['status'] = $request->input('status');
        $section->update($data);

        return response()->json([
            'message' => 'success',
        ]);
        
        
    }

    public function destroy(string $id)
    {
        if($this->permission_type['hr_sales_order_delete'] == true) {

            $response = HrOrderLink::find($id)->delete();
            
            if($response) {
                return response()->json([
                    'message'  => 'success'
                ]);
            }
        }
        return response()->json([
            'message'  => 'fail'
        ]);
    }
}
