<?php

namespace App\Http\Controllers\Admin\Hr;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HrRole;
use App\Models\HrUser;
use App\Models\HrUserPath;
use App\Models\PermissionToUser;
use App\Models\Language;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public $hr_user_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('hr_users', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('hr_user_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_user_show'] = true;
        } else {
            $this->permission_type['hr_user_show'] = false;
        }

        if (array_search('hr_user_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_user_create'] = true;
        } else {
            $this->permission_type['hr_user_create'] = false;
        }

        if (array_search('hr_user_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_user_update'] = true;
        } else {
            $this->permission_type['hr_user_update'] = false;
        }

        if (array_search('hr_user_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['hr_user_delete'] = true;
        } else {
            $this->permission_type['hr_user_delete'] = false;
        }


    }
    
    public function check_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $user = HrUser::where('email', '=', $email);

        if($current) {
            $user = HrUser::where('email', '=', $email)
                    ->where('email', '!=', $current);
        }

        if($user->exists()) {
            return response()->json([
                'email'     => $email,
                'current'   => $current,
                'message'   => 'unavailable'
            ]);
        }

        return response()->json([
            'email'     => $email,
            'current'   => $current,
            'message'   => 'available'
        ]);
    }
    
    public function check_login_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $user = HrUser::where('login_email', '=', $email);

        if($current) {
            $user = HrUser::where('login_email', '=', $email)
                    ->where('login_email', '!=', $current);
        }

        if($user->exists()) {
            return response()->json([
                'message'   => 'unavailable'
            ]);
        }

        return response()->json([
            'message'   => 'available'
        ]);
    }

    public function index()
    {
        $users = HrUser::with(['hr_role', 'hr_user_path.user', 'superior'])->orderBy('id', 'ASC')->get();

        $permission_type['hr_user_show'] = $this->permission_type['hr_user_show'];
        $permission_type['hr_user_create'] = $this->permission_type['hr_user_create'];
        $permission_type['hr_user_update'] = $this->permission_type['hr_user_update'];
        $permission_type['hr_user_delete'] = $this->permission_type['hr_user_delete'];

        return response()->json([
            'users' => $users,
            'permission'    => $this->permission,
            'permission_type' => $permission_type
        ]);
    }

    public function create()
    {
        $permission_type['hr_user_create'] = $this->permission_type['hr_user_create'];
        
        $roles = HrRole::where('status', 1)->get();
        
        $users = HrUser::where('status', 1)->get();
        
        $languages = Language::where('status', 1)->get();

        return response()->json([
            'permission_type'   => $permission_type,
            'roles'             => $roles,
            'users'             => $users,
            'languages'         => $languages
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['hr_user_create'] != true) {
            return response()->json([
                'message' => 'fail',
            ]);
        }
        
        $data['hr_role_id'] = $request->input('role_id');
        $data['superior_id'] = $request->input('superior_id');
        $data['language_id'] = $request->input('language_id');
        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email');
        $data['telephone'] = $request->input('telephone');
        $data['status'] = $request->input('status');
        $data['uniqid'] = uniqid();

        $data['login_email'] = $request->input('login_email');
        $data['password'] = Hash::make($request->input('password'));
        
        $hr_user_res = HrUser::create($data);
        
        $hr_user_path['hr_user_id'] = $hr_user_res->id;
        $hr_user_path['path'] = $hr_user_res->id .'-';
        $hr_user_path['team_director'] = $hr_user_res->id;
        
        $hr_user_path_res = HrUserPath::where('hr_user_id', $request->input('superior_id'));
        
        if($hr_user_path_res->exists()) {
            $hr_user_path['path'] = $hr_user_path_res->first()->path . $hr_user_path['path'];
            $hr_user_path['team_director'] = $hr_user_path_res->first()->team_director;
        }
        
        HrUserPath::create($hr_user_path);
        
        return response()->json([
            'message' => 'success',
        ]);

    }

    public function show(string $id)
    {

        $user = HrUser::find($id);

        $user = HrUser::where('uniqid', $uniqid)->first();

        $permission_type['hr_user_update'] = $this->permission_type['hr_user_update'];

        return response()->json([
            'user' => $user,
            'permission_type' => $permission_type,
        ], 200);

    }

    public function edit(string $uniqid)
    {
        $permission_type['hr_user_update'] = $this->permission_type['hr_user_update'];
        
        $roles = HrRole::where('status', 1)->get();
        
        $users = HrUser::where('uniqid', '!=', $uniqid)->where('status', 1)->get();
        
        $user = HrUser::where('uniqid', $uniqid)->first();
        
        $languages = Language::where('status', 1)->get();

        return response()->json([
            'user'      => $user,
            'users'     => $users,
            'roles'     => $roles,
            'permission_type' => $permission_type,
            'languages'         => $languages
        ], 200);
    }

    public function update(Request $request, string $uniqid)
    {
        if($this->permission_type['hr_user_update'] != true) {
            return response()->json([
                'message' => 'fail',
            ]);
        }

        $hr_user = HrUser::where('uniqid', $uniqid)->first();
        
        $data['hr_role_id'] = $request->input('role_id');
        $data['superior_id'] = $request->input('superior_id');
        $data['language_id'] = $request->input('language_id');
        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email');
        $data['telephone'] = $request->input('telephone');
        $data['status'] = $request->input('status');

        $data['login_email'] = $request->input('login_email');

        if($request->input('password')) {
            $data['password'] = Hash::make($request->input('password'));
        } else {
            $data['password'] = $hr_user->password;
        }
        
        $hr_user->update($data);
        
        HrUserPath::where('hr_user_id', $hr_user->id)->delete();
        
        $hr_user_path['hr_user_id'] = $hr_user->id;
        $hr_user_path['path'] = $hr_user->id .'-';
        $hr_user_path['team_director'] = $hr_user->id;
        
        $hr_user_path_res = HrUserPath::where('hr_user_id', $request->input('superior_id'));
        
        if($hr_user_path_res->exists()) {
            
            $hr_user_path['path'] = $hr_user_path_res->first()->path . $hr_user_path['path'];
            $hr_user_path['team_director'] = $hr_user_path_res->first()->team_director;
            
        } else if($request->input('superior_id') > 0) {
            $hr_user_path['path'] = $request->input('superior_id').'-'.$hr_user->id .'-';    
            $hr_user_path['team_director'] = $hr_user_path_res->first()->team_director;
        } else {
            $hr_user_path['path'] = $hr_user->id .'-';
            $hr_user_path['team_director'] = $hr_user->id;
        }
        
        HrUserPath::create($hr_user_path);

        return response()->json([
            'data'      => $data,
            'message'   => 'success',
        ]);
        
    }

    public function destroy(Request $request, string $id)
    {
        if($this->permission_type['hr_user_delete'] == true) {
            
            $type = $request->input('type');
            
            if($type == 'parent') {
                $hr_user_paths = HrUserPath::all();
                
                foreach($hr_user_paths as $hr_user_path) {
                    $path = explode($id.'-', $hr_user_path->path);
                    $hr_user_path = HrUserPath::find($hr_user_path->id);
                    $path_data['path'] = isset($path[1]) ? $path[0].$path[1] : $path[0];
                    $hr_user_path->update($path_data);
                }
                
                $hr_user = HrUser::find($id);
                
                $hr_user_superior = $hr_user->superior_id;
                
                HrUser::where('superior_id', $id)->update([
                    'superior_id' => $hr_user_superior
                ]);
                
            }
            
            if($type == 'company') {
                $hr_user_paths = HrUserPath::all();
                
                foreach($hr_user_paths as $hr_user_path) {
                    
                    $path = explode($id.'-', $hr_user_path->path);
                    
                    
                    if(isset($path[1])) {
                        $hr_user_path = HrUserPath::find($hr_user_path->id);    
                        
                        $path_data['path'] = $path[1];
                        
                        $hr_user_path->update($path_data);
                    }
                }
                
                HrUser::where('superior_id', $id)->update([
                    'superior_id' => 0
                ]);
            }

            HrUserPath::where('hr_user_id', $id)->delete();
            $response = HrUser::find($id)->delete();
            
            if($response) {
                return response()->json([
                    'path_data' => $path_data,
                    'message'   => 'success'
                ]);
            }
        }
        return response()->json([
            'message'  => 'fail'
        ]);
    }
}
