<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Industry;

class IndustryController extends Controller
{

    public function index()
    {
        $industries = Industry::orderBy('id', 'ASC')->get();

        return response()->json([
            'industries' => $industries,
        ]);
    }

    public function create()
    {

    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data['title'] = $request->input('title');
        $data['sort'] = $request->input('sort');
        $data['status'] = $request->input('status');

        Industry::create($data);

        return response()->json([
            'success' => true,
            'data'      => $data
        ]);

    }


    public function show(string $id)
    {
        //
    }

    public function edit(string $id)
    {
        $industry = Industry::find($id);

        return response()->json([
            'industry' => $industry,
        ], 200);
    }

    public function update(Request $request, string $id)
    {

        $industry = Industry::find($id);

        $data['title'] = $request->input('title');
        $data['sort'] = $request->input('sort');
        $data['status'] = $request->input('status');

        $industry->update($data);

        return response()->json([
            'success' => true,
            'success_message'    => 'update success'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $response = Industry::find($id)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => 'Delete Successful!',
                'text'      => 'Industry has been Deleted!'
            ]);
        }

        return response()->json([
            'response'  => false,
            'title'     => 'Delete Unsuccessful!',
            'text'      => ''
        ]);
    }
}
