<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Language;
use App\Models\PermissionToUser;
use Illuminate\Support\Facades\Hash;

class languageController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('languages', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('language_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['language_show'] = true;
        } else {
            $this->permission_type['language_show'] = false;
        }

        if (array_search('language_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['language_create'] = true;
        } else {
            $this->permission_type['language_create'] = false;
        }

        if (array_search('language_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['language_update'] = true;
        } else {
            $this->permission_type['language_update'] = false;
        }

        if (array_search('language_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['language_delete'] = true;
        } else {
            $this->permission_type['language_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $permission_type['language_show'] = $this->permission_type['language_show'];
        $permission_type['language_create'] = $this->permission_type['language_create'];
        $permission_type['language_update'] = $this->permission_type['language_update'];
        $permission_type['language_delete'] = $this->permission_type['language_delete'];
        
        $languages = Language::all();

        return response()->json([
            'languages'         => $languages,
            'permission'    => $this->permission,
            'permission_type' => $permission_type
        ]);
    }

    public function create()
    {
        $permission_type['language_create'] = $this->permission_type['language_create'];

        // $languages = Language::all();

        return response()->json([
            // 'languages' => $languages,
            'permission_type' => $permission_type
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['language_create'] != true) {
            return response()->json(['success' => false]);
        }
        $data['title'] = $request->input('title');
        $data['locale'] = $request->input('locale');
        $data['status'] = $request->input('status');

        $language = Language::create($data);

        $file = env('APP_LANG_PATH').$data['locale'].".json";

        if(!file_exists($file)) {
            copy(env('APP_LANG_PATH')."demo.json", $file);
        }
        
        return response()->json([
            'path'      => $file,
            'success' => true,
            'data'      => $data
        ]);

    }


    public function show(string $id)
    {
        $permission_type['language_show'] = $this->permission_type['language_show'];
        $language = Language::find($id);

        return response()->json([
            'language'              => $language,
            'permission_type'   => $permission_type
        ]);
    }

    public function edit(string $id)
    {
        $permission_type['language_update'] = $this->permission_type['language_update'];

        $language = Language::find($id);

        return response()->json([
            'language' => $language,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['language_update'] != true) {
            return response()->json(['success' => false]);
        }

        $language = Language::find($id);
        
        $data['title'] = $request->input('title');
        $data['locale'] = $request->input('locale');
        $data['status'] = $request->input('status');
        
        // $new_file = "./../lang/".$data['locale'].".json";
        $new_file = env('APP_LANG_PATH').$data['locale'].".json";
        $old_file = env('APP_LANG_PATH').$language->locale.".json";

        if(!file_exists($old_file)) {
            copy(env('APP_LANG_PATH')."demo.json", $old_file);
        }

        if(!file_exists($new_file)) {
            copy($old_file, $new_file);
            unlink($old_file);
        } 

        $language->update($data);

        return response()->json([
            'success' => true,
            'success_message'    => 'update success'
        ]);

    }

    public function destroy(string $id)
    {
        // if($this->permission_type['language_delete'] != true) {
        //     return response()->json(['success' => false]);
        // }
        $response = Language::where('id', $id)->first();
        
        $file = env('APP_LANG_PATH').$response->locale.".json";
        
        if(file_exists($file)) {
            unlink(env('APP_LANG_PATH').$response->locale.".json");    
        }
        
        if($response) {
            
            Language::find($id)->delete();
            return response()->json([
                'response'  => $response,
                'title'     => '刪除成功!',
                'text'      => '事項刪除成功!'
            ]);
        }

        return response()->json([
            'response'  => false,
            // 'path'      => $path,
            'title'     => '刪除失敗!',
            'text'      => ''
        ]);
    }
}
