<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Permission;
use App\Models\PermissionToUser;
use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\App;

class LoginController extends Controller
{
    public function Login(Request $request)
    {
        $email = $request->input('email');
        $password = $request->input('password');
        session()->flush();
        $user = DB::table('users')->where('email', '=', $email)->where('status', '1')->first();

        if ($user && Hash::check($password,$user->password)) {
            $token = md5(rand(1, 10) . microtime());

            $language_id = $user->language_id;

            $language = Language::where('id', $language_id)->first();

            session([
                'user_email'    => $user->email,
                'user_id'       => $user->id,
                'user_locale'   => $language->locale,
                'locale'        => $language->locale,
                'role_id'       => $user->role_id,
                'session_id'    => $request->session()->regenerate(),
            ]);

            return response()->json([
                'success'       => true,
                'token'         => $token,
                'user_email'    => session('user_email'),
                'staff'         => true,
                'session_id'    => session('session_id'),
                'locale'        => App::currentLocale(),
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Incorrect user credentials',

        ]);
    }

    public function Logout(Request $request)
    {
        $request->session()->flush();
        return response()->json([
            'success' => true,
        ]);
    }

}
