<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Mail\OrderMail;
use App\Mail\MyTestEmail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Models\OrderCustomer;
use App\Models\Setting;
use Illuminate\Support\Facades\Config;


class MailController extends Controller
{

    public function order_email(String $order_id)
    {

        $attachment = Setting::where('key', 'invoice_mail_attachment')->first();
        
        if($attachment->value == "1") {
            $data['file'] = public_path('sales/orders/order_'.$order_id.'.pdf');
        } else {
            $data['file'] = null;
        }
     
        $data['title'] = Setting::where('key', 'invoice_mail_title')->first()->value;
        $data['content'] = Setting::where('key', 'invoice_mail_content')->first()->value;

        $customer = OrderCustomer::where('order_id', $order_id)->orderByDesc('id')->first();

        Config::set('mail.default', Setting::where('key', 'MAIL_MAILER')->first()->value);
        Config::set('mail.mailers.smtp.transport', Setting::where('key', 'MAIL_MAILER')->first()->value);
        // Config::set('mail.mailers.smtp.url', Setting::where('key', 'MAIL_URL')->first()->value);    
        Config::set('mail.mailers.smtp.host', Setting::where('key', 'MAIL_HOST')->first()->value);
        Config::set('mail.mailers.smtp.port', Setting::where('key', 'MAIL_PORT')->first()->value);    
        Config::set('mail.mailers.smtp.encryption', Setting::where('key', 'MAIL_ENCRYPTION')->first()->value);
        Config::set('mail.mailers.smtp.username', Setting::where('key', 'MAIL_USERNAME')->first()->value);
        Config::set('mail.mailers.smtp.password', Setting::where('key', 'MAIL_PASSWORD')->first()->value);
        Config::set('mail.from.address', Setting::where('key', 'MAIL_FROM_ADDRESS')->first()->value);
        Config::set('mail.from.name', Setting::where('key', 'MAIL_FROM_NAME')->first()->value);

        Mail::to($customer->email)->send(new OrderMail($data));
       
    }

}
