<?php

namespace App\Http\Controllers\Admin\Member\Catalogues;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Member\Catalogues\MemberCataloguePointItem;
use App\Models\Admin\Member\MemberLevel;
use App\Models\PermissionToUser;
use App\Models\Language;
use App\Models\CooperationStore;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;

class PointItemController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('member_catalogue_point_items', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }
        
        if (array_search('member_catalogue_point_item_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['show'] = true;
        } else {
            $this->permission_type['show'] = false;
        }

        if (array_search('member_catalogue_point_item_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['create'] = true;
        } else {
            $this->permission_type['create'] = false;
        }

        if (array_search('member_catalogue_point_item_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['update'] = true;
        } else {
            $this->permission_type['update'] = false;
        }

        if (array_search('member_catalogue_point_item_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['delete'] = true;
        } else {
            $this->permission_type['delete'] = false;
        }
    }

    public function index()
    {
        $items = MemberCataloguePointItem::all();

        return response()->json([
            'items'  => $items,
            'permission'   => $this->permission,
            'permission_type'   => $this->permission_type
        ]);
    }
    
    public function create()
    {
        $stores = CooperationStore::where('status', '1')->get();
        
        $member_levels = MemberLevel::where('status', '1')->get();

        return response()->json([
            'stores'         => $stores,
            'member_levels'         => $member_levels,
            'permission_type'   => $this->permission_type
        ]);
    }

    public function store(Request $request)
    {
        $data['cooperation_store_id']   = $request->input('store_id');
        $data['member_level_id']   = $request->input('member_level_id');
        $data['title']                  = $request->input('title');
        $data['description']            = $request->input('description');
        $data['quantity']               = $request->input('quantity');
        $data['price']                  = $request->input('price');
        $data['point']                  = $request->input('point');
        $data['point_extra']            = $request->input('point_extra');
        $data['duration']               = $request->input('duration');
        $data['duration_type']          = $request->input('duration_type');
        $data['tags']                   = $request->input('tags') ?? "";
        $data['sort']                   = $request->input('sort') ?? "";
        $data['image']                  = '';
        $data['uniqid']                 = md5($request->input('title'));
        $data['status']                 = (int)$request->input('status');
        
        $result = MemberCataloguePointItem::create($data);
        
        if($request->hasFile('image')) {
            $item = MemberCataloguePointItem::find($result->id);
            $image = $request->file('image');
            $image_name = time().'_'.$image->getClientOriginalName();
            $data['image'] = 'branch/catalogues/point_item/'.$result->id.'/'.$image_name;
            $image->storeAs('branch/catalogues/point_item/'.$result->id, $image_name, 'public');
            $item->update($data);
        }
        
        if($result) {
            return response()->json([
                'message' => 'success',
            ]);    
        }
        
        return response()->json([
            'message' => 'fail',
        ]);

    }
    
    public function show(string $uniqid)
    {
        $stores = CooperationStore::where('status', '1')->get();
        
        $item = MemberCataloguePointItem::where('uniqid', $uniqid)->first();
        
        $logo_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');

        return response()->json([
            'stores'            => $stores,
            'item'              => $item,
            'permission_type'   => $this->permission_type,
            'logo_path'         => $logo_path
        ]);
    }

    public function edit(string $uniqid)
    {
        $stores = CooperationStore::where('status', '1')->get();
        
        $member_levels = MemberLevel::where('status', '1')->get();
        
        $item = MemberCataloguePointItem::where('uniqid', $uniqid)->first();
        
        $logo_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');

        return response()->json([
            'stores'            => $stores,
            'member_levels'         => $member_levels,
            'item'              => $item,
            'permission_type'   => $this->permission_type,
            'logo_path'         => $logo_path
        ]);
    }

    public function update(Request $request, string $uniqid)
    {
        $item = MemberCataloguePointItem::where('uniqid', $uniqid);

        $data['cooperation_store_id']   = $request->input('store_id');
        $data['member_level_id']        = $request->input('member_level_id');
        $data['title']                  = $request->input('title');
        $data['description']            = $request->input('description');
        $data['quantity']               = $request->input('quantity');
        $data['price']                  = $request->input('price');
        $data['point']                  = $request->input('point');
        $data['point_extra']            = $request->input('point_extra');
        $data['duration']               = $request->input('duration');
        $data['duration_type']          = $request->input('duration_type');
        $data['tags']                   = $request->input('tags') ?? "";
        $data['sort']                   = $request->input('sort') ?? "";
        $data['status']                 = (int)$request->input('status');
        
        if($request->hasFile('image')) {
            Storage::disk('public')->delete($item->first()->image);
            $image = $request->file('image');
            $image_name = time().'_'.$image->getClientOriginalName();
            $data['image'] = 'branch/catalogues/point_item/'.$item->first()->id.'/'.$image_name;
            $image->storeAs('branch/catalogues/point_item/'.$item->first()->id, $image_name, 'public');
            $item->update($data);
        }

        $item->update($data);

        return response()->json([
            'message' => 'success',
        ]);
    }


    public function destroy(string $uniqid)
    {
        $response = MemberCataloguePointItem::where('uniqid', $uniqid)->delete();

        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

    }
}
