<?php

namespace App\Http\Controllers\Admin\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Member\MemberLevel;
use App\Models\PermissionToUser;
use App\Models\Language;

use Illuminate\Support\Facades\DB;

class LevelController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('member_levels', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }
        
        if (array_search('member_level_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['show'] = true;
        } else {
            $this->permission_type['show'] = false;
        }

        if (array_search('member_level_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['create'] = true;
        } else {
            $this->permission_type['create'] = false;
        }

        if (array_search('member_level_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['update'] = true;
        } else {
            $this->permission_type['update'] = false;
        }

        if (array_search('member_level_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['delete'] = true;
        } else {
            $this->permission_type['delete'] = false;
        }
    }

    public function index()
    {
        $levels = MemberLevel::all();

        return response()->json([
            'levels'  => $levels,
            'permission'   => $this->permission,
            'permission_type'   => $this->permission_type
        ]);
    }

    public function store(Request $request)
    {
        
        $data['title'] = $request->input('title');
        $data['purchase_amount'] = $request->input('purchase_amount');
        $data['purchase_time'] = $request->input('purchase_time');
        $data['year_period'] = $request->input('year_period');
        $data['extra_point'] = $request->input('extra_point');
        $data['extra_point_type'] = $request->input('extra_point_type');
        $data['birthday_point'] = $request->input('birthday_point');
        $data['birthday_point_type'] = $request->input('birthday_point_type');
        $data['uniqid'] = uniqid($request->input('title'));
        $data['status'] = (int)$request->input('status');
        
        $response = MemberLevel::create($data);

        return response()->json([
            'message' => 'success',
            'response'  => $response
        ]);

    }
    
    public function show(string $uniqid)
    {
        $level = MemberLevel::where('uniqid', $uniqid)->first();

        return response()->json([
            'level' => $level,
            'permission_type'   => $this->permission_type,
        ]);
    }

    public function edit(string $uniqid)
    {
        $level = MemberLevel::where('uniqid', $uniqid)->first();

        return response()->json([
            'level' => $level,
            'permission_type'   => $this->permission_type,
        ]);
    }

    public function update(Request $request, string $uniqid)
    {
        $level = MemberLevel::where('uniqid', $uniqid);

        $data['title'] = $request->input('title');
        $data['purchase_amount'] = $request->input('purchase_amount');
        $data['purchase_time'] = $request->input('purchase_time');
        $data['year_period'] = $request->input('year_period');
        $data['extra_point'] = $request->input('extra_point');
        $data['extra_point_type'] = $request->input('extra_point_type');
        $data['birthday_point'] = $request->input('birthday_point');
        $data['birthday_point_type'] = $request->input('birthday_point_type');
        $data['status'] = (int)$request->input('status');

        $level->update($data);

        return response()->json([
            'message' => 'success',
        ]);
    }


    public function destroy(string $uniqid)
    {
        $response = MemberLevel::where('uniqid', $uniqid)->delete();

        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

    }
}
