<?php

namespace App\Http\Controllers\Admin\Member\Marketings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Member\Marketings\MemberMarketingCoupon;
use App\Models\PermissionToUser;
use App\Models\Language;
use App\Models\CooperationStore;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;

class CouponController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('member_marketings_coupons', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }
        
        if (array_search('member_marketings_coupon_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['show'] = true;
        } else {
            $this->permission_type['show'] = false;
        }

        if (array_search('member_marketings_coupon_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['create'] = true;
        } else {
            $this->permission_type['create'] = false;
        }

        if (array_search('member_marketings_coupon_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['update'] = true;
        } else {
            $this->permission_type['update'] = false;
        }

        if (array_search('member_marketings_coupon_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['delete'] = true;
        } else {
            $this->permission_type['delete'] = false;
        }
    }

    public function index()
    {
        $coupons = MemberMarketingCoupon::with(['store'])->get();

        return response()->json([
            'coupons'  => $coupons,
            'permission'   => $this->permission,
            'permission_type'   => $this->permission_type
        ]);
    }
    
    public function create()
    {
        $stores = CooperationStore::where('status', '1')->get();

        return response()->json([
            'stores'         => $stores,
            'permission_type'   => $this->permission_type
        ]);
    }

    public function store(Request $request)
    {
        $data['cooperation_store_id']   = $request->input('store_id');
        $data['member_level_id']   = $request->input('member_level_id');
        $data['title']                  = $request->input('title');
        $data['description']            = $request->input('description');
        $data['date_start']               = $request->input('date_start');
        $data['date_end']                  = $request->input('date_end');
        $data['discount_type']                  = $request->input('discount_type');
        $data['discount_value']                   = $request->input('discount_value');
        $data['sort']                   = $request->input('sort');
        $data['code']                  = $request->input('code');
        $data['uniqid']                 = md5($request->input('title'));
        $data['status']                 = (int)$request->input('status');
        
        $result = MemberMarketingCoupon::create($data);

        return response()->json([
            'message' => 'success',
        ]);

    }
    
    public function show(string $uniqid)
    {
        $stores = CooperationStore::where('status', '1')->get();
        
        $item = MemberMarketingCoupon::where('uniqid', $uniqid)->first();
        
        return response()->json([
            'stores'            => $stores,
            'item'              => $item,
            'permission_type'   => $this->permission_type,
        ]);
    }

    public function edit(string $uniqid)
    {
        $stores = CooperationStore::where('status', '1')->get();
        
        $coupon = MemberMarketingCoupon::where('uniqid', $uniqid)->first();
        
        return response()->json([
            'stores'            => $stores,
            'coupon'              => $coupon,
            'permission_type'   => $this->permission_type,
        ]);
    }

    public function update(Request $request, string $uniqid)
    {
        $coupon = MemberMarketingCoupon::where('uniqid', $uniqid);

        $data['cooperation_store_id']   = $request->input('store_id');
        $data['member_level_id']   = $request->input('member_level_id');
        $data['title']                  = $request->input('title');
        $data['description']            = $request->input('description');
        $data['date_start']               = $request->input('date_start');
        $data['date_end']                  = $request->input('date_end');
        $data['discount_type']                  = $request->input('discount_type');
        $data['discount_value']                   = $request->input('discount_value');
        $data['sort']                   = $request->input('sort');
        $data['code']                  = $request->input('code');
        $data['status']                 = (int)$request->input('status');

        $coupon->update($data);

        return response()->json([
            'message' => 'success',
        ]);
    }


    public function destroy(string $uniqid)
    {
        $response = MemberMarketingCoupon::where('uniqid', $uniqid)->delete();

        return response()->json([
            'message'  => 'success',
            'test'      => ''
        ]);

    }
}
