<?php

namespace App\Http\Controllers\Admin\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Member\Member;
use App\Models\PermissionToUser;
use App\Models\Language;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;

class MemberController extends Controller
{
    public $role_id;
    // public $permissions = [];
    public $permission = false;
    public $permission_type = [];

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        // $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('member_members', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }
        
        if (array_search('member_member_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['show'] = true;
        } else {
            $this->permission_type['show'] = false;
        }

        if (array_search('member_member_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['create'] = true;
        } else {
            $this->permission_type['create'] = false;
        }

        if (array_search('member_member_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['update'] = true;
        } else {
            $this->permission_type['update'] = false;
        }

        if (array_search('member_member_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['delete'] = true;
        } else {
            $this->permission_type['delete'] = false;
        }

        // if(!session('role_id')) {
        //     return redirect()->route('login');
        // }
        // $this->role_id = session('role_id');

    }
    
    public function check_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $member = Member::where('email', '=', $email);

        if($current) {
            $member = Member::where('email', '=', $email)
                    ->where('email', '!=', $current);
        }

        if($member->exists()) {
            return response()->json([
                'email'     => $email,
                'current'   => $current,
                'message'   => 'unavailable'
            ]);
        }

        return response()->json([
            'email'     => $email,
            'current'   => $current,
            'message'   => 'available'
        ]);
    }

    public function index()
    {
        $members = Member::all();

        return response()->json([
            'members'  => $members,
            'permission'   => $this->permission,
            'permission_type'   => $this->permission_type
        ]);
    }
    
    public function create()
    {
        $permission_type['create'] = $this->permission_type['create'];
        
        $languages = Language::where('status', 1)->get();

        return response()->json([
            'permission_type'   => $permission_type,
            'languages'     => $languages,
        ]);
    }

    public function store(Request $request)
    {

        $data['honorific'] = $request->input('honorific');
        $data['first_name'] = $request->input('first_name');
        $data['last_name'] = $request->input('last_name');
        $data['email'] = $request->input('email');
        $data['telephone'] = $request->input('telephone');
        $data['birthday'] = $request->input('birthday');
        $data['status'] = (int)$request->input('status');
        $data['password'] = Hash::make($request->input('password'));
        $data['uniqid'] = uniqid($request->input('telephone'));
        $data['referal_code'] = $request->input('referal_code');
        $data['language_id'] = $request->input('language_id');
        $data['verified']   = 0;

        Member::create($data);

        return response()->json([
            'message' => 'success',
        ]);

    }

    public function edit(string $uniqid)
    {
        
        $languages = Language::where('status', 1)->get();
        
        $member = Member::where('uniqid', $uniqid)->first();

        return response()->json([
            'permission_type'   => $this->permission_type,
            'languages'     => $languages,
            'member' => $member,
        ]);
    }
    
    public function show(string $uniqid)
    {
        
        $languages = Language::where('status', 1)->get();
        
        $member = Member::where('uniqid', $uniqid)->first();

        return response()->json([
            'permission_type'   => $this->permission_type,
            'languages'     => $languages,
            'member' => $member,
        ]);
    }

    public function update(Request $request, string $uniqid)
    {
        $member = Member::where('uniqid', $uniqid);

        $data['honorific'] = $request->input('honorific');
        $data['first_name'] = $request->input('first_name');
        $data['last_name'] = $request->input('last_name');
        $data['email'] = $request->input('email');
        $data['telephone'] = $request->input('telephone');
        $data['birthday'] = $request->input('birthday');
        $data['status'] = (int)$request->input('status');
        $data['password'] = Hash::make($request->input('password'));
        $data['referal_code'] = $request->input('referal_code');
        $data['language_id'] = $request->input('language_id');

        $member->update($data);

        return response()->json([
            'message' => 'success',
        ]);
    }


    public function destroy(string $uniqid)
    {
        $response = Member::where('uniqid', $uniqid)->delete();

        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

    }
}
