<?php

namespace App\Http\Controllers\Admin\Member;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Member\MemberMileStone;
use App\Models\PermissionToUser;
use App\Models\Language;

use Illuminate\Support\Facades\DB;

class MileStoneController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('member_mile_stones', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }
        
        if (array_search('member_mile_stone_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['show'] = true;
        } else {
            $this->permission_type['show'] = false;
        }

        if (array_search('member_mile_stone_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['create'] = true;
        } else {
            $this->permission_type['create'] = false;
        }

        if (array_search('member_mile_stone_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['update'] = true;
        } else {
            $this->permission_type['update'] = false;
        }

        if (array_search('member_mile_stone_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['delete'] = true;
        } else {
            $this->permission_type['delete'] = false;
        }
    }

    public function index()
    {
        $mile_stones = MemberMileStone::all();

        return response()->json([
            'mile_stones'  => $mile_stones,
            'permission'   => $this->permission,
            'permission_type'   => $this->permission_type
        ]);
    }

    public function store(Request $request)
    {
        
        $data['title'] = $request->input('title');
        $data['target'] = $request->input('target');
        $data['sort'] = $request->input('sort');
        $data['color_code'] = $request->input('color_code');
        $data['status'] = (int)$request->input('status');
        $data['uniqid'] = md5(str_replace(' ', '_', $request->input('title')));
        
        $response = MemberMileStone::create($data);

        return response()->json([
            'message' => 'success',
            'response'  => $response
        ]);

    }
    
    public function show(string $uniqid)
    {
        $mile_stone = MemberMileStone::where('uniqid', $uniqid)->first();

        return response()->json([
            'mile_stone' => $mile_stone,
            'permission_type'   => $this->permission_type,
        ]);
    }

    public function edit(string $uniqid)
    {
        $mile_stone = MemberMileStone::where('uniqid', $uniqid)->first();

        return response()->json([
            'mile_stone' => $mile_stone,
            'permission_type'   => $this->permission_type,
        ]);
    }

    public function update(Request $request, string $uniqid)
    {
        $mile_stone = MemberMileStone::where('uniqid', $uniqid);

        $data['title'] = $request->input('title');
        $data['target'] = $request->input('target');
        $data['sort'] = $request->input('sort');
        $data['color_code'] = $request->input('color_code');
        $data['status'] = (int)$request->input('status');

        $mile_stone->update($data);

        return response()->json([
            'message' => 'success',
        ]);
    }


    public function destroy(string $uniqid)
    {
        $response = MemberMileStone::where('uniqid', $uniqid)->delete();

        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

    }
}
