<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\OrderTransaction;
use App\Models\PaymentMethod;
use App\Models\PermissionToUser;

class OrderTransactionController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('order_transactions', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('order_transaction_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['order_transaction_show'] = true;
        } else {
            $this->permission_type['order_transaction_show'] = false;
        }

        if (array_search('order_transaction_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['order_transaction_update'] = true;
        } else {
            $this->permission_type['order_transaction_update'] = false;
        }

        if (array_search('order_transaction_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['order_transaction_delete'] = true;
        } else {
            $this->permission_type['order_transaction_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $transactions = OrderTransaction::all();

        $permission_type['order_transaction_show'] = $this->permission_type['order_transaction_show'];
        $permission_type['order_transaction_update'] = $this->permission_type['order_transaction_update'];
        $permission_type['order_transaction_delete'] = $this->permission_type['order_transaction_delete'];

        return response()->json([
            'transactions' => $transactions,
            'permission'   => $this->permission,
            'permission_type'   => $permission_type
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $transaction = OrderTransaction::where('id', $id)->first();
        $payment_methods = PaymentMethod::where('status', '>', 0)->get();

        $permission_type['order_transaction_show'] = $this->permission_type['order_transaction_show'];

        return response()->json([
            'transaction'   => $transaction,
            'payment_methods' => $payment_methods,
            'permission_type' => $permission_type,
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $transaction = OrderTransaction::where('id', $id)->first();
        $payment_methods = PaymentMethod::where('status', '>', 0)->get();

        $permission_type['order_transaction_update'] = $this->permission_type['order_transaction_update'];

        return response()->json([
            'transaction'   => $transaction,
            'payment_methods' => $payment_methods,
            'permission_type' => $permission_type,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        if($this->permission_type['order_transaction_update'] != true) {
            return response()->json(['success' => false]);
        }
        $payment = json_decode($request->input('payment_method'));

        $order_transaction = OrderTransaction::find($id);
        $data['order_id'] = $request->input('order_id');;
        $data['payment_amount'] = $request->input('payment_amount');
        $data['payment_method'] = $payment->title;
        $data['payment_method_id'] = $payment->id;

        $order_transaction->update($data);

        return response()->json([
            'response' => true,
            'id'        => $id,
            'order_id' => $request->input('order_id'),
            'payment_amount'   => $data['payment_amount'],
            'payment_method' => $payment->title,
            'payment_method_id' => $payment->id,
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        if($this->permission_type['order_transaction_delete'] != true) {
            return response()->json(['success' => false]);
        }
        $response = OrderTransaction::find($id)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => '刪除成功',
                'text'      => '付款方法已刪除!'
            ]);
        }

        return response()->json([
            'response'  => false,
            'title'     => '刪除失敗!',
            'text'      => ''
        ]);
    }
}
