<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Project;
use App\Models\Customer;
use App\Models\User;
use App\Models\ProjectStatus;
use App\Models\Task;
use App\Models\TaskStatus;
use App\Models\PermissionToUser;

class ProjectController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('projects', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('project_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['project_show'] = true;
        } else {
            $this->permission_type['project_show'] = false;
        }

        if (array_search('project_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['project_create'] = true;
        } else {
            $this->permission_type['project_create'] = false;
        }

        if (array_search('project_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['project_update'] = true;
        } else {
            $this->permission_type['project_update'] = false;
        }

        if (array_search('project_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['project_delete'] = true;
        } else {
            $this->permission_type['project_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $permission_type['project_show'] = $this->permission_type['project_show'];
        $permission_type['project_create'] = $this->permission_type['project_create'];
        $permission_type['project_update'] = $this->permission_type['project_update'];
        $permission_type['project_delete'] = $this->permission_type['project_delete'];
        
        $today = date("Y-m-d");
        $projects = Project::orderBy('id', 'ASC')->orderBy('expiry_date')->get();

        return response()->json([
            'projects' => $projects,
            'permission'    => $this->permission,
            'permission_type' => $permission_type
        ]);
    }

    public function create()
    {
        $permission_type['project_create'] = $this->permission_type['project_create'];

        $customers = Customer::where('status', 1)->get();

        $staffs = User::where('status', 1)->get();

        $status = ProjectStatus::with(['detail'])->where('status', 1)->get();

        return response()->json([
            'customers' => $customers,
            'staffs'    => $staffs,
            'status'    => $status,
            'permission_type' => $permission_type
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['project_create'] != true) {
            return response()->json([
                'success' => false,
            ]);
        }
        
        $customer_type = $request->input('customer_type');
        if($customer_type == 'existing_customer') {
            $data['customer_id'] = $request->input('customer_id');

            $customer = Customer::where('id', $request->input('customer_id'))->first();
            $data['contact_person'] = $customer->name;
            $data['telephone'] = $customer->telephone;

        }

        if($customer_type == 'custom_customer') {
            $data['contact_person'] = $request->input('contact_person');
            $data['telephone'] = $request->input('telephone');
        }

        $data['expiry_date'] = $request->input('project_expiry_date');
        $data['title'] = $request->input('title');
        $data['order_id'] = $request->input('order_id');
        $data['status'] = $request->input('status');
        $data['comment'] = $request->input('comment');
        $data['staff_id'] = session('user_id');
        $project = Project::create($data);

        $tasks =  json_decode($request->input('tasks'));

        $TaskStatus = TaskStatus::where('default', 1)->first();

        foreach($tasks as $task) {
            $task_data['project_id'] = $project->id;
            $task_data['title'] = $task->title;
            $task_data['description'] = $task->description;
            $task_data['expiry_date'] = $task->expiry_date;
            $task_data['staff_id'] = $task->staff->id;
            $task_data['status'] = $TaskStatus->id ?? 0;

            Task::create($task_data);
        }
        return response()->json([
            'success' => true,
            'data'      => $data,
            'user'      => session('user_id')
        ]);

    }

    public function show(string $id)
    {
        $project = Project::with(['tasks'])->where('id', $id)->first();
        $customers = Customer::where('status', 1)->get();
        $staffs = User::where('status', 1)->get();
        $status = ProjectStatus::where('status', 1)->get();
        $permission_type['project_show'] = $this->permission_type['project_show'];

        return response()->json([
            'customers'         => $customers,
            'staffs'            => $staffs,
            'status'            => $status,
            'project'           => $project,
            'permission_type'   => $permission_type['project_show']
        ], 200);
    }

    public function edit(string $id)
    {
        $project = Project::with(['tasks'])->where('id', $id)->first();
        $customers = Customer::where('status', 1)->get();
        $staffs = User::where('status', 1)->get();
        $status = ProjectStatus::with(['detail'])->where('status', 1)->get();
        $permission_type['project_update'] = $this->permission_type['project_update'];

        return response()->json([
            'customers' => $customers,
            'staffs'    => $staffs,
            'status'    => $status,
            'project' => $project,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['project_update'] != true) {
            return response()->json([
                'success' => false,
            ]);
        }
        $customer_type = $request->input('customer_type');
        if($customer_type == 'existing_customer') {
            $data['customer_id'] = $request->input('customer_id');

            $customer = Customer::where('id', $request->input('customer_id'))->first();
            $data['contact_person'] = $customer->name;
            $data['telephone'] = $customer->telephone;

        }

        if($customer_type == 'custom_customer') {
            $data['customer_id'] = null;
            $data['contact_person'] = $request->input('contact_person');
            $data['telephone'] = $request->input('telephone');
        }

        $project = Project::find($id);
        $data['expiry_date'] = $request->input('project_expiry_date');
        $data['title'] = $request->input('title');
        $data['order_id'] = $request->input('order_id');
        $data['status'] = $request->input('status');
        $data['comment'] = $request->input('comment');
        $data['staff_id'] = session('user_id');
        $project->update($data);

        $TaskStatus = TaskStatus::where('default', 1)->first();

        Task::where('project_id', $id)->delete();

        $tasks =  json_decode($request->input('tasks'));
        foreach($tasks as $task) {
            $task_data['project_id'] = $project->id;
            $task_data['title'] = $task->title;
            $task_data['description'] = $task->description;
            $task_data['expiry_date'] = $task->expiry_date;
            $task_data['staff_id'] = $task->staff->id;
            $task_data['status'] = $TaskStatus->id ?? 0;

            Task::create($task_data);
        }
        return response()->json([
            'success' => true,
            'data'      => $data,
            'user'      => session('user_id')
        ]);
    }


    public function destroy(string $id)
    {

        if($this->permission_type['project_delete'] == true) {
            return response()->json([
                'response'  => false,
                'title'     => 'Delete Unsuccessful!',
                'text'      => ''
            ]);
        }
        Task::where('project_id', $id)->delete();

        $response = Project::find($id)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => 'Delete Successful!',
                'text'      => 'project has been Deleted!'
            ]);
        }

        
    }
}
