<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Permission;
use Illuminate\Http\Request;
use App\Models\Role;
use App\Models\PermissionToUser;
use Illuminate\Auth\Events\Login;
use Illuminate\Contracts\Session\Session;

class RoleController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type = [];

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        foreach($permissions as $permission) {
            $this->permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('roles', array_column($this->permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('role_show', array_column($this->permission_type, 'permission'))) {
            $this->permission_type['role_show'] = true;
        } else {
            $this->permission_type['role_show'] = false;
        }

        if (array_search('role_create', array_column($this->permission_type, 'permission'))) {
            $this->permission_type['role_create'] = true;
        } else {
            $this->permission_type['role_create'] = false;
        }

        if (array_search('role_update', array_column($this->permission_type, 'permission'))) {
            $this->permission_type['role_update'] = true;
        } else {
            $this->permission_type['role_update'] = false;
        }

        if (array_search('role_delete', array_column($this->permission_type, 'permission'))) {
            $this->permission_type['role_delete'] = true;
        } else {
            $this->permission_type['role_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function role_permissions()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        return response()->json([
            'permissions' => $permissions,
        ]);
        
    }

    public function index()
    {
        $permission_type['role_show'] = $this->permission_type['role_show'];
        $permission_type['role_create'] = $this->permission_type['role_create'];
        $permission_type['role_update'] = $this->permission_type['role_update'];
        $permission_type['role_delete'] = $this->permission_type['role_delete'];

        $roles = Role::orderBy('id', 'ASC')->get();

        return response()->json([
            'roles'             => $roles,
            'permission'        => $this->permission,
            'permission_type'   => $permission_type
        ]);
    }

    public function create()
    {
        $permission_type['role_create'] = $this->permission_type['role_create'];

        $permissions = Permission::with('children')
                        ->where('parent_id', '=', null)
                        ->orderBy('sort', 'asc')->get();

        return response()->json([
            'permissions' => $permissions,
            'permission_type'   => $permission_type,
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['role_create'] != true) {
            return response()->json([
                'success' => false
            ]);
        }
        $data['title'] = $request->input('title');
        $data['status'] = $request->input('status');
        $permissions = json_decode($request->input('permissions'));

        $role = Role::where('title', '=', $request->input('title'));

        if($role->exists()) {
            return response()->json([
                'success'   => false,
                'message'   => 'role title exist'
            ]);
        }

        $role = Role::create($data);

        foreach($permissions as $permission) {
            $data['role_id'] = $role->id;
            $data['permission'] = $permission;
            PermissionToUser::create($data);
        }

        return response()->json([
            'success' => true,
            'data'      => $data
        ]);
    }

    public function show(string $id)
    {
        $permission_type['role_show'] = $this->permission_type['role_show'];
        $role = Role::find($id);
        $permissions = Permission::with('children')
                        ->where('parent_id', '=', null)
                        ->orderBy('id', 'asc')->get();
        $permission_to_users = PermissionToUser::where('role_id', '=', $id)->get();

        return response()->json([
            'role'          => $role,
            'permissions' => $permissions,
            'permission_to_users'   => $permission_to_users,
            'permission_type'   => $permission_type,
        ], 200);
    }

    public function edit(string $id)
    {
        $permission_type['role_update'] = $this->permission_type['role_update'];
        $role = Role::find($id);
        $permissions = Permission::with('children')
                        ->where('parent_id', '=', null)
                        ->orderBy('id', 'asc')->get();
        $permission_to_users = PermissionToUser::where('role_id', '=', $id)->get();

        return response()->json([
            'role'          => $role,
            'permissions' => $permissions,
            'permission_to_users'   => $permission_to_users,
            'permission_type'   => $permission_type,
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['role_update'] != true) {
            return response()->json([
                'success' => false
            ]);
        }

        $role = Role::where('id', '=', $id)->first();
        $role->title = $request->input('title');
        $role->status = $request->input('status');
        $role->update($request->all());

        PermissionToUser::where('role_id', $id)->delete();

        $permissions = json_decode($request->input('permissions'));

        foreach($permissions as $permission) {
            $data['role_id'] = $id;
            $data['permission'] = $permission;
            PermissionToUser::create($data);
        }

        return response()->json([
            'message'    => 'success',
        ]);
    }

    public function destroy(string $id)
    {
        if($this->permission_type['role_delete'] != true) {
            return response()->json([
                'success' => false
            ]);
        }

        $response = Role::find($id)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => 'Delete Successful!',
                'message'      => 'Role has been Deleted!'
            ]);
        }

        return response()->json([
            'response'  => false,
            'title'     => 'Delete Unsuccessful!',
            'message'      => ''
        ]);

    }
}
