<?php

namespace App\Http\Controllers\Admin\Sales;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use App\Models\PaymentMethodDetail;
use App\Models\PermissionToUser;
use App\Models\Language;

class PaymentMethodController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('payment_methods', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('payment_method_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['payment_method_show'] = true;
        } else {
            $this->permission_type['payment_method_show'] = false;
        }

        if (array_search('payment_method_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['payment_method_create'] = true;
        } else {
            $this->permission_type['payment_method_create'] = false;
        }

        if (array_search('payment_method_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['payment_method_update'] = true;
        } else {
            $this->permission_type['payment_method_update'] = false;
        }

        if (array_search('payment_method_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['payment_method_delete'] = true;
        } else {
            $this->permission_type['payment_method_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $payment_methods = PaymentMethod::with(['detail'])->orderBy('id', 'ASC')->get();

        $permission_type['payment_method_show'] = $this->permission_type['payment_method_show'];
        $permission_type['payment_method_create'] = $this->permission_type['payment_method_create'];
        $permission_type['payment_method_update'] = $this->permission_type['payment_method_update'];
        $permission_type['payment_method_delete'] = $this->permission_type['payment_method_delete'];


        return response()->json([
            'payment_methods' => $payment_methods,
            'permission'    => $this->permission,
            'permission_type' => $permission_type,
        ]);
    }

    public function create()
    {
        $permission_type['payment_method_create'] = $this->permission_type['payment_method_create'];

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'permission_type'   => $permission_type,
            'languages'         => $languages,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        if($this->permission_type['payment_method_create'] != true) {
            return response()->json(['success' => false]);
        }
        
        $data['upload_receipt'] = false;
        $data['upload_payment_record'] = false;
        
        if($request->input('upload_receipt') == "true") {
            $data['upload_receipt'] = true;    
        }
        
        if($request->input('upload_payment_record') == "true") {
            $data['upload_payment_record'] = true;    
        }
        
        $data['status'] = $request->input('status');
        $data['sort'] = $request->input('sort');

        $payment = PaymentMethod::create($data);

        foreach(json_decode($request->input('details')) as $v) 
        {
            $data['payment_method_id']    = $payment->id;
            $data['language_locale']    = $v->language_locale;
            $data['title']    = $v->title;

            PaymentMethodDetail::create($data);
        }

        return response()->json([
            'message' => 'success',
            'data' => $data
        ]);

    }


    public function show(string $id)
    {
        $payment_method = PaymentMethod::with(['details'])->find($id);

        $permission_type['payment_method_show'] = $this->permission_type['payment_method_show'];

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'payment_method' => $payment_method,
            'permission_type'   => $permission_type,
            'languages'         => $languages,
        ], 200);
    }

    public function edit(string $id)
    {
        $payment_method = PaymentMethod::with(['details'])->find($id);

        $permission_type['payment_method_update'] = $this->permission_type['payment_method_update'];

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'payment_method' => $payment_method,
            'permission_type'   => $permission_type,
            'languages'         => $languages,
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['payment_method_update'] != true) {
            return response()->json(['success' => false]);
        }
        $payment_method = PaymentMethod::find($id);
        $data['upload_receipt'] = false;
        $data['upload_payment_record'] = false;
        
        if($request->input('upload_receipt') == "true") {
            $data['upload_receipt'] = true;    
        }
        
        if($request->input('upload_payment_record') == "true") {
            $data['upload_payment_record'] = true;    
        }
        
        $data['status'] = $request->input('status');
        $data['sort'] = $request->input('sort');
        $payment_method->update($data);

        PaymentMethodDetail::where('payment_method_id', $id)->delete();

        foreach(json_decode($request->input('details')) as $v) 
        {
            $data['payment_method_id']    = $id;
            $data['language_locale']    = $v->language_locale;
            $data['title']    = $v->title;

            PaymentMethodDetail::create($data);
        }

        return response()->json([
            'message' => 'success',
        ]);
    }

    public function destroy(string $id)
    {
        // if($this->permission_type['payment_method_delete'] != true) {
        //     return response()->json(['success' => false]);
        // }
        PaymentMethodDetail::where('payment_method_id', $id)->delete();
        $response = PaymentMethod::find($id)->delete();

        return response()->json([
            'message' => 'success',
        ]);
    }
}
