<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Models\PermissionToUser;

class SettingController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('system', array_column($permission_type, 'permission'))) {
            $this->permission['system'] = true;
        } else {
            $this->permission['system'] = false;
        }

        if (array_search('users', array_column($permission_type, 'permission'))) {
            $this->permission['users'] = true;
        } else {
            $this->permission['users'] = false;
        }

        if (array_search('roles', array_column($permission_type, 'permission'))) {
            $this->permission['roles'] = true;
        } else {
            $this->permission['roles'] = false;
        }

        if (array_search('user_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['user_show'] = true;
        } else {
            $this->permission_type['user_show'] = false;
        }

        if (array_search('user_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['user_create'] = true;
        } else {
            $this->permission_type['user_create'] = false;
        }

        if (array_search('user_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['user_update'] = true;
        } else {
            $this->permission_type['user_update'] = false;
        }

        if (array_search('user_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['user_delete'] = true;
        } else {
            $this->permission_type['user_delete'] = false;
        }

        if (array_search('role_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['role_show'] = true;
        } else {
            $this->permission_type['role_show'] = false;
        }

        if (array_search('role_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['role_create'] = true;
        } else {
            $this->permission_type['role_create'] = false;
        }

        if (array_search('role_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['role_update'] = true;
        } else {
            $this->permission_type['role_update'] = false;
        }

        if (array_search('role_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['role_delete'] = true;
        } else {
            $this->permission_type['role_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function systemIndex()
    {
        $logoImg = Setting::where('key', 'logoImgPreview')->first();
  
        $logo = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/'.$logoImg->value);
        
        $faviconImg = Setting::where('key', 'faviconImgPreview')->first();
        $favicon = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/'.$faviconImg->value);
        
        
        $data = Setting::where('type', '=', 'system')->get();
        

        return response()->json([
            'logo'  => $logo,
            'favicon'    => $favicon,
            'data'  => $data,
            'permission'    => $this->permission['system'],
        ]);
    }

    public function systemUpdate(Request $request)
    {
        $data = [];
        $data['shop_name'] = $request->input('shop_name');
        $data['address'] = $request->input('address');
        $data['currency'] = $request->input('currency');
        $data['currency_symbol'] = $request->input('currency_symbol');
        $data['decimal'] = $request->input('decimal');

        if($request->hasFile('logoImg') && $request->hasFile('logoImgPreview')) {
            $logo = Setting::where('key', '=','logoImg')->first();

            // Storage::disk('setting/system')->delete($logo->value);
            // Storage::delete('setting/system'.$logo->value);
            Storage::disk('public')->delete('setting/system/'.$logo->value);

            $image = $request->file('logoImg');
            $data['logoImg'] = time().'_'.$image->getClientOriginalName();
            $data['logoImgPreview'] = 'setting/system/'.$data['logoImg'];
            $image->storeAs('setting/system', $data['logoImg'], 'public');
            // $image->move(public_path('setting/system'), $data['logoImg']);
            // $image->move(public_path('setting/invoice/'), $data['invoice_logo']);
        }

        if($request->hasFile('faviconImg') && $request->hasFile('faviconImgPreview')) {
            $favicon = Setting::where('key', '=','faviconImg')->first();

            Storage::disk('public')->delete('setting/system/'.$favicon->value);

            $image = $request->file('faviconImg');
            $data['faviconImg'] = time().'_'.$image->getClientOriginalName();
            $data['faviconImgPreview'] = 'setting/system/'.$data['faviconImg'];
            $image->storeAs('setting/system', $data['faviconImg'], 'public');

        }

        foreach($data as $k => $v) {
            Setting::updateOrCreate(
                ['type' => 'system', 'key' => $k],
                ['value' => $v]
            );
        }

        return response()->json([
            'success'   => true,
            'shop_name' => $request->input('shop_name'),
            'data'      => $data
        ]);

    }

    public function invoiceIndex()
    {
        $data = Setting::where('type', 'invoice')->get();

        return response()->json([
            'success'   => true,
            'data'      => $data
        ]);
    }

    public function invoiceUpdate(Request $request)
    {
        $data['invoice_customer_address'] = $request->input('invoice_customer_address');
        $data['invoice_company_address'] = $request->input('invoice_company_address');
        $data['invoice_conditions'] = $request->input('invoice_conditions');
        $data['invoice_footer'] = $request->input('invoice_footer');
        $data['invoice_mail_title'] = $request->input('invoice_mail_title');
        $data['invoice_mail_attachment'] = $request->input('invoice_mail_attachment');
        $data['invoice_mail_content'] = $request->input('invoice_mail_content');

        if($request->hasFile('invoice_logo') && $request->hasFile('invoice_logo_preview')) {
            $invoice = Setting::where('key', '=','invoice_logo')->first();
            File::delete(public_path($invoice->value));

            $image = $request->file('invoice_logo');
            $data['invoice_logo'] = '/setting/invoice/'.time().'_'.$image->getClientOriginalName();
            $data['invoice_logo_preview'] = $data['invoice_logo'];
            $image->move(public_path('setting/invoice/'), $data['invoice_logo']);
        }


        foreach($data as $k => $v) {
            Setting::updateOrCreate(
                ['type' => 'invoice', 'key' => $k],
                ['value' => $v]
            );
        }

        return response()->json([
            'success'   => true,
            'data'      => $data
        ]);
    }

    public function mailIndex(Request $request)
    {
        $data = Setting::where('type', 'mail')->get();

        return response()->json([
            'success'   => true,
            'data'      => $data
        ]);
    }

    public function mailUpdate(Request $request)
    {
        $data['MAIL_MAILER'] = $request->input('MAIL_MAILER');
        $data['MAIL_HOST'] = $request->input('MAIL_HOST');
        $data['MAIL_PORT'] = $request->input('MAIL_PORT');
        $data['MAIL_USERNAME'] = $request->input('MAIL_USERNAME');
        $data['MAIL_PASSWORD'] = $request->input('MAIL_PASSWORD');
        $data['MAIL_ENCRYPTION'] = $request->input('MAIL_ENCRYPTION');
        $data['MAIL_FROM_ADDRESS'] = $request->input('MAIL_FROM_ADDRESS');
        $data['MAIL_FROM_NAME'] = $request->input('MAIL_FROM_NAME');

        

        foreach($data as $k => $v) {
            
            Setting::updateOrCreate(
                ['type' => 'mail', 'key' => $k],
                ['value' => $v]
            );
        }

        return response()->json([
            'success'   => true,
            'data'      => $data,
        ]);
    }

    public function stripeIndex() {
        $data = Setting::where('type', '=', 'stripe')->get();

        return response()->json([
            'data'  => $data,
        ]);
    }

    public function stripeUpdate(Request $request) {
        $data = [];
        $data['publishable_key'] = $request->input('publishable_key');
        $data['secret_key'] = $request->input('secret_key');

        foreach($data as $k => $v) {
            Setting::updateOrCreate(
                ['type' => 'stripe', 'key' => $k],
                ['value' => $v]
            );
        }

        return response()->json([
            'success'   => true,
        ]);
    }
    
    public function paypalIndex() {
        $data = Setting::where('type', '=', 'paypal')->get();

        return response()->json([
            'data'  => $data,
        ]);
    }

    public function paypalUpdate(Request $request) {
        $data = [];
        $data['option'] = $request->input('option');
        $data['email'] = $request->input('email');
        $data['SANDBOX_PAYPAL_CLIENT_ID'] = $request->input('SANDBOX_PAYPAL_CLIENT_ID') ?? "";
        $data['SANDBOX_PAYPAL_CLIENT_SECRET'] = $request->input('SANDBOX_PAYPAL_CLIENT_SECRET') ?? "";
        $data['PAYPAL_CLIENT_ID'] = $request->input('PAYPAL_CLIENT_ID') ?? "";
        $data['PAYPAL_CLIENT_SECRET'] = $request->input('PAYPAL_CLIENT_SECRET') ?? "";
        $data['remark'] = $request->input('remark') ?? "";

        foreach($data as $k => $v) {
            Setting::updateOrCreate(
                ['type' => 'paypal', 'key' => $k],
                ['value' => $v]
            );
        }

        return response()->json([
            'success'   => true,
        ]);
    }

    public function twillioIndex() {
        $data = Setting::where('type', '=', 'twillio')->get();

        return response()->json([
            'data'  => $data,
        ]);
    }

    public function twillioUpdate(Request $request) {
        $data = [];
        $data['mobile_number'] = $request->input('mobile_number');
        $data['account_sid'] = $request->input('account_sid');
        $data['auth_token'] = $request->input('auth_token');

        foreach($data as $k => $v) {
            Setting::updateOrCreate(
                ['type' => 'twillio', 'key' => $k],
                ['value' => $v]
            );
        }

        return response()->json([
            'success'   => true,
        ]);
    }
}
