<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\CooperationCompany;
use App\Models\CooperationStore;
use App\Models\Language;
use App\Models\PermissionToUser;
use Illuminate\Support\Facades\App;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Env;
use Illuminate\Support\Facades\File;

class StoreController extends Controller
{

    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        app::setlocale(session('locale'));
        
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('cooperation_stores', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        } else {
            $this->permission = false;
        }

        if (array_search('cooperation_store_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['store_show'] = true;
        } else {
            $this->permission_type['store_show'] = false;
        }

        if (array_search('cooperation_store_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['store_create'] = true;
        } else {
            $this->permission_type['store_create'] = false;
        }

        if (array_search('cooperation_store_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['store_update'] = true;
        } else {
            $this->permission_type['store_update'] = false;
        }

        if (array_search('cooperation_store_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['store_delete'] = true;
        } else {
            $this->permission_type['store_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }
    
    public function check_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $store_email = CooperationStore::where('email', '=', $email);

        if($current) {
            $store_email = CooperationStore::where('email', '=', $email)
                    ->where('email', '!=', $current);
        }

        if($store_email->exists()) {
            return response()->json([
                'email'     => $email,
                'current'   => $current,
                'message'   => 'unavailable',
            ]);
        }

        return response()->json([
            'email'     => $email,
            'current'   => $current,
            'message'   => 'available'
        ]);
    }
    
    public function check_login_email(Request $request)
    {
        $current = $request->input('current');
        $login_email = $request->input('login_email');

        $store_login_email = CooperationStore::where('login_email', '=', $login_email);

        if($current) {
            $store_login_email = CooperationStore::where('login_email', '=', $login_email)
                            ->where('login_email', '!=', $current);
        }

        if($store_login_email->exists()) {
            return response()->json([
                'currenct'  => $current,
                'login_email' => $login_email,
                'message'   => 'unavailable',
            ]);
        }

        return response()->json([
            'currenct'  => $current,
            'login_email' => $login_email,
            'message'   => 'available'
        ]);
    }

    public function index()
    {
        $permission_type['store_show'] = $this->permission_type['store_show'];
        $permission_type['store_create'] = $this->permission_type['store_create'];
        $permission_type['store_update'] = $this->permission_type['store_update'];
        $permission_type['store_delete'] = $this->permission_type['store_delete'];

        $stores = CooperationStore::with(['company'])->get();

        return response()->json([
            'stores' => $stores,
            'permission'    => $this->permission,
            'permission_type' => $permission_type,
            'locale'    => session('locale'),
        ]);
    }

    public function create()
    {
        
        $permission_type['store_create'] = $this->permission_type['store_create'];
        
        $companies = CooperationCompany::where('status', '=', '1')->get();
        
        $languages = Language::where('status', "1")->get();
        
        $categories = Category::with(['detail'])->where('status', '1')->get();

        return response()->json([
            'permission_type'   => $permission_type,
            'companies'         => $companies,
            'languages'         => $languages,
            'categories'        => $categories,
            'locale'            => App::currentLocale(),
        ]);
    }

    public function store(Request $request)
    {
        $data['cooperation_company_id'] = $request->input('company');
        $data['language_id'] = $request->input('language_id');
        
        $language = Language::where('id', $request->input('language_id'))->first();
        
        $data['language_locale'] = $language->locale;
        
        $data['name'] = $request->input('name');
        $data['telephone'] = $request->input('telephone');
        $data['email'] = $request->input('email');
        $data['address'] = $request->input('address') ?? "";
        $data['business_hours'] = $request->input('business_hours') ?? "";
        $data['status'] = $request->input('status');
        
        $data['login_email'] = $request->input('login_email');
        $data['password'] = Hash::make($request->input('password'));
        
        $data['category_array'] = $request->input('category_array');
        
        $data['notify'] = $request->input('notify');
        
        $data['logo'] = "";
        
        $data['uniqid'] = uniqid();
        
        $image = "";
        
        if($request->input('change_password') == "true") {
            $data['require_update_password'] = "1";
        } else {
            $data['require_update_password'] = "0";
        }

        $result = CooperationStore::create($data);
        
        if($request->hasFile('logo')) {
            $store = CooperationStore::find($result->id);
            $image = $request->file('logo');
            $image_name = time().'_'.$image->getClientOriginalName();
            $data['logo'] = 'cooperation/store/'.$result->id.'/'.$image_name;
            $image->storeAs('cooperation/store/'.$result->id, $image_name, 'public');
            $store->update($data);
        }

        return response()->json([
            'data'      => $data,
            'message'   => 'success'
        ]);
    }

    public function show(string $id)
    {
        $permission_type['store_show'] = $this->permission_type['store_show'];

        $companies = CooperationCompany::where('status', '=', '1')->get();
        
        $store = CooperationStore::find($id);
        
        $languages = Language::where('status', "1")->get();

        return response()->json([
            'companies'         => $companies,
            'store'             => $store,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function edit(string $id)
    {
        $permission_type['store_update'] = $this->permission_type['store_update'];

        $companies = CooperationCompany::where('status', '=', '1')->get();
        
        $store = CooperationStore::where('id', $id)->first();
        
        $languages = Language::where('status', "1")->get();
        
        $logo_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');
        
        $categories = Category::with(['detail'])->where('status', '1')->get();
        
        return response()->json([
            'companies'         => $companies,
            'store'             => $store,
            'languages'         => $languages,
            'permission_type'   => $permission_type,
            'logo_path'         => $logo_path,
            'categories'        => $categories
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        $store = CooperationStore::find($id);
        
        if($store->uniqid == null) {
            $data['uniqid'] = uniqid();
        }
        
        $data['cooperation_company_id'] = $request->input('company');
        
        $data['language_id'] = $request->input('language_id');
        
        $language = Language::where('id', $request->input('language_id'))->first();
        
        $data['language_locale'] = $language->locale;
        
        $data['name'] = $request->input('name');
        $data['telephone'] = $request->input('telephone');
        $data['email'] = $request->input('email');
        $data['address'] = $request->input('address');
        $data['business_hours'] = $request->input('business_hours');
        $data['status'] = $request->input('status');
        
        $data['category_array'] = $request->input('category_array');
        
        $data['login_email'] = $request->input('login_email');
        if($request->input('password')) {
            // $customer->password = Hash::make($request->input('password'));
            $data['password'] = Hash::make($request->input('password'));
        }
        
        if($request->hasFile('logo')) {

            Storage::disk('public')->delete($store->logo);
            $image = $request->file('logo');
            $image_name = time().'_'.$image->getClientOriginalName();
            $data['logo'] = 'cooperation/store/'.$id.'/'.$image_name;
            $image->storeAs('cooperation/store/'.$id, $image_name, 'public');

        }

        $result = $store->update($data);

        if($result) {
            return response()->json([
                'status' => true,
                'message'    => 'success'
            ]);    
        }
        
        return response()->json([
            'message'    => 'fail'
        ]);
        
    }

    public function destroy(string $id)
    {
        
        $response = CooperationStore::find($id)->delete();

        if($response) {
            return response()->json([
                'status'  => true,
                'message'     => 'delete.success',
            ]);
        }

        return response()->json([
            'status'  => false,
            'title'     => 'Delete Unsuccessful!',
            'text'      => ''
        ]);
    }
}
