<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Task;
use App\Models\Customer;
use App\Models\User;
use App\Models\TaskStatus;
use App\Models\PermissionToUser;

class TaskController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('tasks', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('task_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['task_show'] = true;
        } else {
            $this->permission_type['task_show'] = false;
        }

        if (array_search('task_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['task_create'] = true;
        } else {
            $this->permission_type['task_create'] = false;
        }

        if (array_search('task_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['task_update'] = true;
        } else {
            $this->permission_type['task_update'] = false;
        }

        if (array_search('task_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['task_delete'] = true;
        } else {
            $this->permission_type['task_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $permission_type['task_show'] = $this->permission_type['task_show'];
        $permission_type['task_create'] = $this->permission_type['task_create'];
        $permission_type['task_update'] = $this->permission_type['task_update'];
        $permission_type['task_delete'] = $this->permission_type['task_delete'];

        $tasks = Task::with(['user', 'task_status'])->orderBy('id', 'ASC')->orderBy('expiry_date')->get();

        return response()->json([
            'tasks' => $tasks,
            'permission'    => $this->permission,
            'permission_type' => $permission_type
        ]);
    }

    public function create()
    {
        $permission_type['task_create'] = $this->permission_type['task_create'];

        $status = TaskStatus::with(['detail'])->where('status', 1)->get();

        return response()->json([
            'status'    => $status,
            'permission_type' => $permission_type
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['task_create'] != true) {
            return response()->json([
                'success' => false,
            ]);
        }
        
        $data['expiry_date'] = $request->input('expiry_date');
        $data['title'] = $request->input('title');
        $data['description'] = $request->input('description');
        $data['project_id'] = $request->input('project_id');
        $data['status'] = $request->input('status');
        $data['staff_id'] = session('user_id');
        Task::create($data);

        return response()->json([
            'success' => true,
            'data'      => $data,
            'user'      => session('user_id')
        ]);

    }

    public function show(string $id)
    {
        $status = TaskStatus::where('status', 1)->get();
        $task = Task::where('id', $id)->first();

        $permission_type['task_show'] = $this->permission_type['task_show'];

        return response()->json([
            'status'    => $status,
            'task'      => $task,
            'permission_type' => $permission_type
        ]);
    }

    public function edit(string $id)
    {
        $status = TaskStatus::with(['detail'])->where('status', 1)->get();
        $task = Task::where('id', $id)->first();
        $permission_type['task_update'] = $this->permission_type['task_update'];

        return response()->json([
            'status'    => $status,
            'task'      => $task,
            'permission_type' => $permission_type
        ]);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['task_update'] != true) {
            return response()->json([
                'success'   => false,
            ]);
        }
        $task = Task::find($id);
        $data['title'] = $request->input('title');
        $data['description'] = $request->input('description');
        $data['project_id'] =  $request->input('project_id');
        $data['expiry_date'] =  $request->input('expiry_date');
        $data['status'] = $request->input('status');

        $task->update($data);
        return response()->json([
            'success' => true,
            'success_message'    => 'update success'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        if($this->permission_type['task_delete'] != true) {
            return response()->json([
                'success'   => false,
            ]);
        }

        $response = Task::find($id)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => 'Delete Successful!',
                'text'      => 'task has been Deleted!'
            ]);
        }

        return response()->json([
            'response'  => false,
            'title'     => 'Delete Unsuccessful!',
            'text'      => ''
        ]);
    }
}
