<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\TaskStatus;
use App\Models\TaskStatusDetail;
use App\Models\PermissionToUser;
use App\Models\Language;

class TaskStatusController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type;

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        $permission_type = [];

        foreach($permissions as $permission) {
            $permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('task_status', array_column($permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('task_status_show', array_column($permission_type, 'permission'))) {
            $this->permission_type['task_status_show'] = true;
        } else {
            $this->permission_type['task_status_show'] = false;
        }

        if (array_search('task_status_create', array_column($permission_type, 'permission'))) {
            $this->permission_type['task_status_create'] = true;
        } else {
            $this->permission_type['task_status_create'] = false;
        }

        if (array_search('task_status_update', array_column($permission_type, 'permission'))) {
            $this->permission_type['task_status_update'] = true;
        } else {
            $this->permission_type['task_status_update'] = false;
        }

        if (array_search('task_status_delete', array_column($permission_type, 'permission'))) {
            $this->permission_type['task_status_delete'] = true;
        } else {
            $this->permission_type['task_status_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function index()
    {
        $permission_type['task_status_show'] = $this->permission_type['task_status_show'];
        $permission_type['task_status_create'] = $this->permission_type['task_status_create'];
        $permission_type['task_status_update'] = $this->permission_type['task_status_update'];
        $permission_type['task_status_delete'] = $this->permission_type['task_status_delete'];

        $statuses = TaskStatus::with(['detail'])->orderBy('id', 'ASC')->get();

        return response()->json([
            'statuses' => $statuses,
            'permission'    => $this->permission,
            'permission_type' => $permission_type
        ]);
    }

    public function create()
    {
        $permission_type['task_status_create'] = $this->permission_type['task_status_create'];

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'permission_type' => $permission_type,
            'languages'         => $languages,
        ]);
    }

    
    public function store(Request $request)
    {
        if($this->permission_type['task_status_create'] != true) {
            return response()->json([
                'success' => false,
            ]);
        }
        
        $data['status'] = $request->input('status');
        $data['sort'] = $request->input('sort');

        $status = TaskStatus::create($data);

        foreach(json_decode($request->input('details')) as $v) 
        {
            $data['task_status_id']    = $status->id;
            $data['language_locale']    = $v->language_locale;
            $data['title']    = $v->title;

            TaskStatusDetail::create($data);
        }

        return response()->json([
            'success' => true,
            'data'      => $data
        ]);

    }


    public function show(string $id)
    {
        $status = TaskStatus::with(['details'])->find($id);
        $permission_type['task_status_show'] = $this->permission_type['task_status_show'];

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'status' => $status,
            'permission_type' => $permission_type,
            'languages'         => $languages,
        ], 200);
    }

    public function edit(string $id)
    {
        $status = TaskStatus::with(['details'])->find($id);
        $permission_type['task_status_update'] = $this->permission_type['task_status_update'];

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'status' => $status,
            'permission_type' => $permission_type,
            'languages'         => $languages,
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['task_status_update'] != true) {
            return response()->json([
                'success' => false,
            ]);
        }
        $status = TaskStatus::find($id);
        $data['sort'] = $request->input('sort');
        $data['status'] = $request->input('status');

        $status->update($data);

        TaskStatusDetail::where('task_status_id', $id)->delete();

        foreach(json_decode($request->input('details')) as $v) 
        {
            $data['task_status_id']    = $id;
            $data['language_locale']    = $v->language_locale;
            $data['title']    = $v->title;

            TaskStatusDetail::create($data);
        }

        return response()->json([
            'success' => true,
            'success_message'    => 'update success'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        if($this->permission_type['task_status_delete'] != true) {
            return response()->json([
                'response'  => false,
                'title'     => '刪除失敗!',
                'text'      => ''
            ]);
        }

        TaskStatusDetail::where('task_status_id', $id)->delete();
        $response = TaskStatus::find($id)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => '刪除成功',
                'text'      => '付款方法已刪除!'
            ]);
        }

        
    }
}
