<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Role;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Language;
use Illuminate\Support\Facades\Hash;
use App\Models\PermissionToUser;

class UserController extends Controller
{
    public $role_id;
    public $permission = false;
    public $permission_type = [];

    public function __construct()
    {
        $permissions = PermissionToUser::where('role_id', session('role_id'))->get();

        foreach($permissions as $permission) {
            $this->permission_type[] = array(
                'permission'    => $permission->permission,
            );
        }

        if (array_search('users', array_column($this->permission_type, 'permission'))) {
            $this->permission = true;
        }

        if (array_search('user_show', array_column($this->permission_type, 'permission'))) {
            $this->permission_type['user_show'] = true;
        } else {
            $this->permission_type['user_show'] = false;
        }

        if (array_search('user_create', array_column($this->permission_type, 'permission'))) {
            $this->permission_type['user_create'] = true;
        } else {
            $this->permission_type['user_create'] = false;
        }

        if (array_search('user_update', array_column($this->permission_type, 'permission'))) {
            $this->permission_type['user_update'] = true;
        } else {
            $this->permission_type['user_update'] = false;
        }

        if (array_search('user_delete', array_column($this->permission_type, 'permission'))) {
            $this->permission_type['user_delete'] = true;
        } else {
            $this->permission_type['user_delete'] = false;
        }

        if(!session('role_id')) {
            return redirect()->route('login');
        }
        $this->role_id = session('role_id');

    }

    public function check_email(Request $request)
    {
        $current = $request->input('current');
        $email = $request->input('email');

        $user = User::where('email', '=', $email);

        if($current) {
            $user = User::where('email', '=', $email)
                    ->where('email', '!=', $current);
        }

        if($user->exists()) {
            return response()->json([
                'email'     => $email,
                'current'   => $current,
                'message'   => 'user email exist'
            ]);
        }

        return response()->json([
            'email'     => $email,
                'current'   => $current,
            'message'   => 'User Available'
        ]);
    }
    
    public function check_company_email(Request $request)
    {
        $current = $request->input('current');
        $company_email = $request->input('company_email');

        $user = User::where('company_email', '=', $company_email);

        if($current) {
            $current_company_email = User::where('company_email', '=', $company_email)
                    ->where('company_email', '!=', $current);
        }

        if($user->exists()) {
            return response()->json([
                'company_email'     => $company_email,
                'current'   => $current,
                'message'   => 'user email exist'
            ]);
        }

        return response()->json([
            'company_email'     => $company_email,
                'current'   => $current,
            'message'   => 'User Available'
        ]);
    }

    public function index()
    {
        $permission_type['user_show'] = $this->permission_type['user_show'];
        $permission_type['user_create'] = $this->permission_type['user_create'];
        $permission_type['user_update'] = $this->permission_type['user_update'];
        $permission_type['user_delete'] = $this->permission_type['user_delete'];

        $users = User::orderBy('id', 'ASC')->get();

        $roles = Role::where('status', '>', 0)->get();

        return response()->json([
            'users' => $users,
            'roles' => $roles,
            'permission'    => $this->permission,
            'permission_type'   => $permission_type,
            'hello' => 'hello'
        ]);
    }

    public function create()
    {
        $permission_type['user_create'] = $this->permission_type['user_create'];
        $roles = Role::where('status', '1')->get();
        $languages = Language::where('status', '1')->get();

        return response()->json([
            'roles' => $roles,
            'languages'     => $languages,
            'permission_type'   => $permission_type
        ]);
    }

    public function store(Request $request)
    {
        if($this->permission_type['user_create'] != true) {
            return response()->json(['success' => false]);
        }

        $data['role_id'] = $request->input('role_id');
        $data['name'] = $request->input('name');
        $data['email'] = $request->input('email');
        $data['company_email'] = $request->input('company_email');
        $data['telephone'] = $request->input('telephone');
        $data['language_id'] = $request->input('language_id');
        $data['password'] = Hash::make($request->input('password'));
        $data['status'] = $request->input('status');

        $user = User::where('email', '=', $data['email']);

        if($user->exists()) {
            return response()->json([
                'success'   => false,
                'message'   => 'user_email_exist'
            ]);
        }

        User::create($data);
        return response()->json([
            'success' => true,
            'message'   => 'user_create_success',
            'data'      => $data
        ]);
    }

    public function show(string $id)
    {
        $permission_type['user_show'] = $this->permission_type['user_show'];

        $user = User::find($id);

        $roles = Role::where('status', '1')->get();

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'user' => $user,
            'roles' => $roles,
            'languages'     => $languages,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function edit(string $id)
    {

        $permission_type['user_update'] = $this->permission_type['user_update'];

        $user = User::find($id);

        $roles = Role::where('status', '1')->get();

        $languages = Language::where('status', '1')->get();

        return response()->json([
            'user' => $user,
            'roles' => $roles,
            'languages'     => $languages,
            'permission_type'   => $permission_type
        ], 200);
    }

    public function update(Request $request, string $id)
    {
        if($this->permission_type['user_update'] != true) {
            return response()->json(['success' => false]);
        }
        $user = User::where('email', '=', $request->input('email'))->where('id', '!=', $id);

        if($user->exists()) {
            return response()->json([
                'success'   => false,
                'user_message'   => 'user email exist'
            ]);
        }

        $user = User::where('id', '=', $id)->first();
        $user->role_id = $request->input('role_id');
        $user->language_id = $request->input('language_id');
        $user->name = $request->input('name');
        $user->email = $request->input('email');
        $user->company_email = $request->input('company_email');
        

        if($request->input('password')) {
            $user->password = Hash::make($request->input('password'));
        }

        $user->update($request->all());
        
        if(session('user_id') == $id) {
            $language = Language::where('id', $request->input('language_id'))->first();

            session([
                'user_locale'   => $language->locale,
                'locale'        => $language->locale,
            ]);    
        }

        return response()->json([
            'success' => true,
            'success_message'    => 'update success'
        ]);
    }

    public function destroy(string $id)
    {
        if($this->permission_type['user_delete'] != true) {
            return response()->json(['success' => false]);
        }

        $response = User::find($id)->delete();

        if($response) {
            return response()->json([
                'response'  => $response,
                'title'     => 'Delete Successful!',
                'text'      => 'User has been Deleted!'
            ]);
        }

        return response()->json([
            'response'  => false,
            'title'     => 'Delete Unsuccessful!',
            'text'      => ''
        ]);

    }
}
