<?php

namespace App\Http\Controllers\Branch;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Session\SessionManager;
use App\Models\Appointment;
use App\Models\AppointmentSection;
use App\Models\AppointmentStatus;

class AppointmentController extends Controller
{
    
    public function index()
    {
        
        $appointments = Appointment::with(['section', 'statusdetail', 'customer', 'hr_user_link.hr_user'])->where('store_id', session('store_id'))->orderByDesc('id')->get();

        $status_options = AppointmentStatus::with(['detail'])->where('status', "1")->get();

        return response()->json([
            'language_id'       => session('language_id'),
            'locale'            => session('locale'),
            'appointments'      => $appointments,
            'status_options'    => $status_options,
            'store_id'          => session('store_id')
        ]);
    }
    
    public function update(Request $request, string $id)
    {
        $appointment = Appointment::find($id);
        
        $data['status'] = $request->input('status');
        
        $appointment->update($data);
        
        return response()->json([
            'message' => 'success',
        ]);
    }

}
