<?php

namespace App\Http\Controllers\Branch\Catelog;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BranchCategory;
use Illuminate\Support\Facades\App;
use Illuminate\Contracts\Database\Eloquent\Builder;


class CategoryController extends Controller
{

    public function index()
    {
 
        $categories = BranchCategory::where('cooperation_store_id', session('store_id'))->get();

        return response()->json([
            'categories' => $categories,
            'store_id'  => session('store_id')
        ]);
    }

    public function create()
    {

    }

    public function store(Request $request)
    {
        $data['cooperation_store_id']  = session('store_id');
        $data['title']  = $request->input('title');
        $data['sort'] = $request->input('sort') ?? "";
        $data['status'] = $request->input('status');

        $result = BranchCategory::create($data);
        
        if($result) {
            return response()->json([
                'message' => 'success'
            ]);    
        }
        
        return response()->json([
            'message' => 'fail'
        ]);

    }

    public function show(string $id)
    {
        
    }

    public function edit(string $id)
    {

        $category = BranchCategory::where('id', $id)->where('cooperation_store_id', session('store_id'))->first();
        
        if($category) {
            return response()->json([
                'category'          => $category,
            ], 200);    
        }
        
        return response()->json([
            'message'          => 'fail',
        ], 200);
        
    }

    public function update(Request $request, string $id)
    {
     
        $category = BranchCategory::where('id', $id)->where('cooperation_store_id', session('store_id'));
        $data['title']  = $request->input('title');
        $data['sort'] = $request->input('sort') ?? "";
        $data['status'] = $request->input('status');

        $result = $category->update($data);

        if($result) {
            return response()->json([
                'message' => 'success',
            ]);    
        }
        
        return response()->json([
            'message' => 'fail',
        ]);
        
    }

    public function destroy(string $id)
    {
        BranchCategory::where('id', $id)->where('cooperation_store_id', session('store_id'))->delete();

        return response()->json([
            'message'  => 'success',
        ]);
        
    }
}
