<?php

namespace App\Http\Controllers\Branch\Catelog;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BranchCategory;
use App\Models\BranchItem;
use Illuminate\Support\Facades\App;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Env;
use Illuminate\Support\Facades\File;


class ItemController extends Controller
{

    public function index()
    {
        $items = BranchItem::with(['category'])->where('cooperation_store_id', session('store_id'))->orderBy('sort', 'ASC')->get();

        return response()->json([
            'items' => $items,
        ]);
    }

    public function create()
    {
        
        $category_array = BranchCategory::where('cooperation_store_id', session('store_id'))->orderBy('sort', 'ASC')->get();
        
        return response()->json([
            'category_array' => $category_array
        ]);
    }

    public function store(Request $request)
    {
        $data['branch_category_id']  = $request->input('category_id');
        $data['cooperation_store_id']  = session('store_id');
        $data['title']  = $request->input('title');
        $data['description']  = $request->input('description');
        $data['price']  = $request->input('price');
        $data['sort'] = $request->input('sort') ?? "";
        $data['status'] = $request->input('status');
        $data['type'] = $request->input('type');
        $data['image'] = '';
        
        $result = BranchItem::create($data);
        
        if($request->hasFile('image')) {
            $item = BranchItem::find($result->id);
            $image = $request->file('image');
            $image_name = time().'_'.$image->getClientOriginalName();
            $data['image'] = 'branch/catalog/item/'.$result->id.'/'.$image_name;
            $image->storeAs('branch/catalog/item/'.$result->id, $image_name, 'public');
            $item->update($data);
        }
        
        if($result) {
            return response()->json([
                'message' => 'success'
            ]);    
        }
        
        return response()->json([
            'message' => 'fail'
        ]);

    }

    public function show(string $id)
    {
        
    }

    public function edit(string $id)
    {

        $item = BranchItem::where('id', $id)->where('cooperation_store_id', session('store_id'))->first();
        
        $category_array = BranchCategory::where('cooperation_store_id', session('store_id'))->orderBy('sort', 'ASC')->get();
        
        $logo_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');
        
        if($category_array) {
            return response()->json([
                'item'              => $item,
                'category_array'    => $category_array,
                'logo_path'         => $logo_path
            ], 200);    
        }
        
        return response()->json([
            'message'          => 'fail',
        ], 200);
        
    }

    public function update(Request $request, string $id)
    {
     
        $item = BranchItem::where('id', $id)->where('cooperation_store_id', session('store_id'))->first();
        
        if($item != null) {
            $item = BranchItem::find($id);
            $data['branch_category_id']  = $request->input('category_id');
            $data['title']  = $request->input('title');
            $data['description']  = $request->input('description');
            $data['price']  = $request->input('price');
            $data['sort'] = $request->input('sort') ?? "";
            $data['status'] = $request->input('status');
            $data['type'] = $request->input('type');
        
            if($request->hasFile('image')) {
                Storage::disk('public')->delete($item->image);
                $image = $request->file('image');
                $image_name = time().'_'.$image->getClientOriginalName();
                $data['image'] = 'branch/catalog/item/'.$id.'/'.$image_name;
                $image->storeAs('branch/catalog/item/'.$id, $image_name, 'public');
            }

            $result = $item->update($data);

            if($result) {
                return response()->json([
                    'message'   => 'success',
                ]);    
            }
        }
        return response()->json([
            'message' => 'fail',
        ]);
    }

    public function destroy(string $id)
    {
        BranchItem::where('id', $id)->where('cooperation_store_id', session('store_id'))->delete();

        return response()->json([
            'message'  => 'success',
        ]);
        
    }
}
