<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use App\Models\CooperationStore;
use App\Models\Language;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\App;

class LoginController extends Controller
{
    public function index() 
    {
        
    }
    
    public function Login(Request $request)
    {
        $email = $request->input('email');
        $password = $request->input('password');
        session()->flush();
        
        $branch = CooperationStore::where('login_email', '=', $email)->where('status', '1')->first();

        if (Hash::check($password, $branch->password)) {
            
            $token = md5(rand(1, 10) . microtime());
            
            $language_id = $branch->language_id;
            
            $language = Language::where('id', $language_id)->first();
            
            session([
                'language_id'   => $language->language_id,
                'locale'        => $language->locale,
                'branch_email'  => $branch->email,
                'login_type'    => 'branch',
                'store_id'      => $branch->id,
                'session_id'    => $request->session()->regenerate(),
            ]);

            return response()->json([
                'message'       => 'success',
                'login_type'    => 'branch',
                'token'         => $token,
            ]);
        }

        return response()->json([
            // 'email'     => $email,
            // 'password'     => $password,
            'message' => 'fail',
            // 'message' => 'Incorrect user credentials',
            

        ]);
    }

    public function Logout(Request $request)
    {
        $request->session()->flush();
        return response()->json([
            'success' => true,
        ]);
    }

}
