<?php

namespace App\Http\Controllers\Branch\Member\Catalogues;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Member\Catalogues\MemberCatalogueRedeemItem;
use App\Models\Admin\Member\MemberLevel;
use App\Models\PermissionToUser;
use App\Models\Language;
use App\Models\CooperationStore;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Env;
use Illuminate\Support\Facades\File;

use Illuminate\Support\Facades\DB;

class RedeemItemController extends Controller
{

    public function index()
    {
        $items = MemberCatalogueRedeemItem::where('cooperation_store_id', session('store_id'))->get();
        
        return response()->json([
            'items'  => $items,
            'store_id' => session('store_id')
        ]);
    }
    
    public function create()
    {
        
        $member_levels = MemberLevel::where('status', '1')->get();

        return response()->json([
            'member_levels'         => $member_levels,
        ]);
    }

    public function store(Request $request)
    {
       
        $data['cooperation_store_id'] = session('store_id');
        $data['title'] = $request->input('title');
        $data['member_level_id']   = $request->input('member_level_id');
        $data['description'] = $request->input('description');
        $data['quantity'] = $request->input('quantity');
        $data['price'] = $request->input('price');
        $data['redeem_points'] = $request->input('redeem_points');
        $data['tags'] = $request->input('tags') ?? "";
        $data['sort'] = $request->input('sort');
        $data['image'] = "";
        $data['uniqid'] = md5($request->input('title'));
        $data['status'] = (int)$request->input('status');
        
        $result = MemberCatalogueRedeemItem::create($data);
        
        if($request->hasFile('image')) {
            $item = MemberCatalogueRedeemItem::find($result->id);
            $image = $request->file('image');
            $image_name = time().'_'.$image->getClientOriginalName();
            $data['image'] = 'branch/catalogues/redeem_items/'.$result->id.'/'.$image_name;
            $image->storeAs('branch/catalogues/redeem_items/'.$result->id, $image_name, 'public');
            $item->update($data);
        }

        return response()->json([
            'message' => 'success',
        ]);

    }
    
    public function show(string $uniqid)
    {
        $item = MemberCatalogueRedeemItem::where('uniqid', $uniqid)->first();
        
        $logo_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');

        return response()->json([
            'item' => $item,
            'logo_path'         => $logo_path
        ]);
    }

    public function edit(string $uniqid)
    {
        $item = MemberCatalogueRedeemItem::where('uniqid', $uniqid)->where('cooperation_store_id', session('store_id'))->first();
        
        $member_levels = MemberLevel::where('status', '1')->get();
        
        $logo_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');

        return response()->json([
            'item' => $item,
            'member_levels'         => $member_levels,
            'logo_path'         => $logo_path
        ]);
    }

    public function update(Request $request, string $uniqid)
    {
        $item = MemberCatalogueRedeemItem::where('uniqid', $uniqid)->where('cooperation_store_id', session('store_id'));

        $data['title'] = $request->input('title');
        $data['member_level_id']   = $request->input('member_level_id');
        $data['description'] = $request->input('description');
        $data['quantity'] = $request->input('quantity');
        $data['price'] = $request->input('price');
        $data['redeem_points'] = $request->input('redeem_points');
        $data['tags'] = $request->input('tags') ?? "";
        $data['sort'] = $request->input('sort');
        $data['status'] = (int)$request->input('status');
        
        if($request->hasFile('image')) {
            Storage::disk('public')->delete($item->first()->image);
            $image = $request->file('image');
            $image_name = time().'_'.$image->getClientOriginalName();
            $data['image'] = 'branch/catalogues/redeem_items/'.$item->first()->id.'/'.$image_name;
            $image->storeAs('branch/catalogues/redeem_items/'.$item->first()->id, $image_name, 'public');
            $item->update($data);
        }

        $item->update($data);

        return response()->json([
            'message' => 'success',
        ]);
    }


    public function destroy(string $uniqid)
    {
        $response = MemberCatalogueRedeemItem::where('uniqid', $uniqid)->where('cooperation_store_id', session('store_id'))->delete();

        if($response) {
            return response()->json([
                'message'  => 'success',
            ]);
        }

    }
}
