<?php

namespace App\Http\Controllers\Branch\Member\Marketings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Member\Marketings\MemberMarketingCoupon;
use App\Models\Admin\Member\MemberLevel;
use App\Models\Language;
use App\Models\CooperationStore;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;

class CouponController extends Controller
{
    

    public function index()
    {
        $coupons = MemberMarketingCoupon::where('cooperation_store_id', session('store_id'))->get();

        return response()->json([
            'coupons'  => $coupons,
           
        ]);
    }
    
    public function create()
    {
        $member_levels = MemberLevel::where('status', '1')->get();

        return response()->json([
            'member_levels'         => $member_levels,
        ]);
    }

    public function store(Request $request)
    {
        $data['cooperation_store_id']   = session('store_id');
        $data['member_level_id']   = $request->input('member_level_id');
        $data['title']                  = $request->input('title');
        $data['description']            = $request->input('description');
        $data['date_start']               = $request->input('date_start');
        $data['date_end']                  = $request->input('date_end');
        $data['discount_type']                  = $request->input('discount_type');
        $data['discount_value']                   = $request->input('discount_value');
        $data['sort']                   = $request->input('sort');
        $data['code']                  = $request->input('code');
        $data['uniqid']                 = md5($request->input('title'));
        $data['status']                 = (int)$request->input('status');
        
        $result = MemberMarketingCoupon::create($data);

        return response()->json([
            'message' => 'success',
        ]);

    }
    
    public function show(string $uniqid)
    {
        
        $coupon = MemberMarketingCoupon::where('uniqid', $uniqid)->where('cooperation_store_id', session('store_id'))->first();
        
        return response()->json([
            'coupon'        => $coupon,
        ]);
    }

    public function edit(string $uniqid)
    {
        $member_levels = MemberLevel::where('status', '1')->get();
        
        $coupon = MemberMarketingCoupon::where('uniqid', $uniqid)->where('cooperation_store_id', session('store_id'))->first();
        
        return response()->json([
            'member_levels' => $member_levels,
            'coupon'        => $coupon,
        ]);
    }

    public function update(Request $request, string $uniqid)
    {
        $coupon = MemberMarketingCoupon::where('uniqid', $uniqid)->where('cooperation_store_id', session('store_id'));

        $data['member_level_id']   = $request->input('member_level_id');
        $data['title']                  = $request->input('title');
        $data['description']            = $request->input('description');
        $data['date_start']               = $request->input('date_start');
        $data['date_end']                  = $request->input('date_end');
        $data['discount_type']                  = $request->input('discount_type');
        $data['discount_value']                   = $request->input('discount_value');
        $data['sort']                   = $request->input('sort');
        $data['code']                  = $request->input('code');
        $data['status']                 = (int)$request->input('status');

        $coupon->update($data);

        return response()->json([
            'message' => 'success',
        ]);
    }


    public function destroy(string $uniqid)
    {
        $response = MemberMarketingCoupon::where('uniqid', $uniqid)->delete();

        return response()->json([
            'message'  => 'success',
            'test'      => ''
        ]);

    }
}
