<?php

namespace App\Http\Controllers\Branch\Member\Sales;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Branch\Member;
use App\Models\Branch\MemberOrder;
use App\Models\Branch\MemberPoint;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Env;
use Illuminate\Support\Facades\File;

use Illuminate\Support\Facades\DB;

class OrderController extends Controller
{
    
    public function search_member(Request $request)
    {
        
        $member = null;
        
        if($request->input('type') == 'telephone') 
        {
            $country_code = $request->input('country_code');
            $telephone = $request->input('telephone');
            
            $result = Member::where('country_code', 'LIKE', '%'.$country_code.'%')->where('telephone', $telephone);
            
            if($result->exists()) 
            {
                // $available_points = MemberPoint::where('id', $result->first()->id)->where('expiry_date', '>', date('Y-m-d'))->sum('point');
                $member = $result->first();
            }
        }
        
        if($request->input('type') == 'email') 
        {
            $email = $request->input('email');
            
            $result = Member::where('email', $email);
            
            if($result->exists()) 
            {
                $member = $result->first();
            }
        }
        
        if($member != null)
        {
            return response()->json([
                'message'      => 'success',
                'member'  => $member
            ]);
        } else {
            return response()->json([
                'message'      => 'fail',
            ]);    
        }
        
        
        
        
    }
    
    public function index()
    {
        $orders = MemberOrder::with(['status'])->where('store_id', session('store_id'))->where('type', 'Redeem')->orderBy('order_date', 'desc')->get();
        
        return response()->json([
            'orders'      => $orders,
            'store_id'  => session('store_id')
        ]);
    }
    
    public function create()
    {
        
        $stores = CooperationStore::where('status', '1')->get();

        return response()->json([
            'stores'         => $stores,
            'permission_type'   => $this->permission_type
        ]);
    }

    public function store(Request $request)
    {
       
        $data['cooperation_store_id'] = $request->input('store_id');
        $data['title'] = $request->input('title');
        $data['description'] = $request->input('description');
        $data['quantity'] = $request->input('quantity');
        $data['redeem_points'] = $request->input('redeem_points');
        $data['tags'] = $request->input('tags') ?? "";
        $data['sort'] = $request->input('sort');
        $data['image'] = "";
        $data['uniqid'] = md5($request->input('title'));
        $data['status'] = (int)$request->input('status');
        
        $result = MemberCatalogueRedeemItem::create($data);
        
        if($request->hasFile('image')) {
            $item = MemberCatalogueRedeemItem::find($result->id);
            $image = $request->file('image');
            $image_name = time().'_'.$image->getClientOriginalName();
            $data['image'] = 'branch/catalogues/redeem_items/'.$result->id.'/'.$image_name;
            $image->storeAs('branch/catalogues/redeem_items/'.$result->id, $image_name, 'public');
            $item->update($data);
        }

        return response()->json([
            'message' => 'success',
        ]);

    }
    
    public function show(string $uniqid)
    {
        $item = MemberCatalogueRedeemItem::where('uniqid', $uniqid)->first();
        
        $logo_path = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/');

        return response()->json([
            'item' => $item,
            'permission_type'   => $this->permission_type,
            'logo_path'         => $logo_path
        ]);
    }


}
