<?php

namespace App\Http\Controllers\Branch;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\BranchOrder;
use App\Models\BranchOrderItem;
use App\Models\BranchOrderTransaction;
use App\Models\BranchItem;
use App\Models\BranchCustomer;
use App\Models\Appointment;
use App\Models\Customer;
use App\Models\PaymentMethod;
use App\Models\OrderStatus;
use App\Models\CustomerPackage;
use App\Models\HrBranchOrderLink;
use App\Models\HrAppointmentLink;
use App\Models\HrUser;
use App\Models\HrOther;
use App\Models\HrCommissionUser;
use App\Models\HrCommissionTeam;
use App\Models\ItemOverrideCommission;

use Illuminate\Support\Facades\Hash;
use Illuminate\Contracts\Database\Eloquent\Builder;
use Barryvdh\DomPDF\Facade\Pdf;
use PHPUnit\Event\Telemetry\System;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class OrderController extends Controller
{
    public function index()
    {
        $orders =   BranchOrder::where('cooperation_store_id', session('store_id'))->get();

        return response()->json([
            'orders' => $orders,
        ]);
    }
    
    public function create(string $appointment_id = null)
    {
        $appointment = null;
        $appointments = Appointment::with(['customer', 'packages', 'hr_user_link'])->where('store_id', session('store_id'))->get();
        
        $appointment_customers = Appointment::select('customer_id');
        
        if($appointment_id != null) {
            $appointment = Appointment::with('packages.item.detail')->where('id', $appointment_id)->where('store_id', session('store_id'))->first();
            $appointment_customers = Appointment::select('customer_id')->where('id', $appointment_id);
        }
        
        $customers = Customer::with(['branch_packages.stores'])->whereIn('id', $appointment_customers)->get();
        
        $branch_customers = BranchCustomer::where('cooperation_store_id', session('store_id'))->get();
        
        $items = BranchItem::where('cooperation_store_id', session('store_id'))->where('status', '1')->get();
        
        $payment_methods = PaymentMethod::with(['detail'])->where('status', '1')->orderBy('sort', 'ASC')->get();
        
        $order_statuses = OrderStatus::with(['detail'])->where('status', 1)->orderBy('sort', 'ASC')->get();
        
        $store_id = session('store_id');
        
        return response()->json([
            'appointment_id'    => $appointment_id,
            'appointment'      => $appointment,
            'appointments'      => $appointments,
            'items'             => $items,
            'customers'         => $customers,
            'branch_customers'  => $branch_customers,
            'payment_methods'   => $payment_methods,
            'order_statuses'    => $order_statuses,
            'store_id'          => $store_id
        ]);
    }
    
    public function store(Request $request)
    {
        $order_date = $request->input('order_date');
        
        $data['cooperation_store_id'] = session('store_id');
        $data['order_date'] = $order_date;
        $data['customer_type'] = $request->input('customer_type');
        
        $appointment_id = $request->input('appointment_id');
        
        $data['customer_id'] = "";
        $data['branch_customer_id'] = "";
        $hr_user_id = "";
        $payable_amount = 0;
        
        $override_commission_item = ItemOverrideCommission::all();
        
        $appointment = Appointment::where('id', $request->input('appointment_id'))->first();
        $data['appointment_id'] = $appointment->id != null ? $request->input('appointment_id') : "";
        
        if($request->input('customer_type') == 'appointment_customer') {
            
            $customer = Customer::where('id', $appointment->customer_id)->first();
            $data['customer_id'] = $appointment->customer_id;
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
        }
        
        if($request->input('customer_type') == 'branch_customer') {
            
            $branch_customer_id = $request->input('order_customer');
            
            $customer = BranchCustomer::where('id', $branch_customer_id)->first();
            
            $data['branch_customer_id'] = $branch_customer_id;
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
        }
        
        if($request->input('customer_type') == 'custom_customer') {
            $customer = json_decode($request->input('order_custom_customer'));
            
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
            
            $data['customer_type'] = 'branch_customer';
            
            $branch_customer['cooperation_store_id'] = session('store_id');
            $branch_customer['name'] = $customer->name;
            $branch_customer['telephone'] = $customer->telephone;
            $branch_customer['email'] = $customer->email;
            $branch_customer['country_code'] = $customer->country_code;
            
            $new_branch_customer = BranchCustomer::create($branch_customer);
            
            $data['branch_customer_id'] = $new_branch_customer->id;
        }
        
        $data['comment'] = $request->input('comment') ?? "";
        
        $data['total'] = $request->input('grand_total');
        
        $data['status_id'] = $request->input('order_status_id');

        $status = OrderStatus::with(['detail'])->where('id', $request->input('order_status_id'))->first();
        
        $data['status'] = $status->detail->title ?? NULL;
        
        $data['uniqid'] = uniqid();

        $branch_order = BranchOrder::create($data);
        
        if(isset($appointment_id)) {
            $hr_appointment_link = HrAppointmentLink::where('appointment_id', $appointment_id)->first();
            if($hr_appointment_link) {
                $hr_branch_order_link['branch_order_id'] = $branch_order->id;
                $hr_branch_order_link['hr_user_id'] = $hr_appointment_link->hr_user_id;
                $hr_user_id = $hr_appointment_link->hr_user_id;
                $hr_branch_order_link['appointment_id'] = $appointment_id;
                HrBranchOrderLink::create($hr_branch_order_link);    
            }
        }

        $payment_method = PaymentMethod::with(['detail'])->where('id', $request->input('payment_method_id'))->first();
        
        $order_transaction['receipt_image'] = "";
        
        if($request->hasFile('upload_receipt_image')) {
            
            $image = $request->file('upload_receipt_image');
            $order_transaction['receipt_image'] = 'branch/sale/transaction/'.time().'_'.$image->getClientOriginalName();
            $image->storeAs('', $order_transaction['receipt_image'], 'public');

        }
        
        $order_transaction['payment_image'] = "";
        
        if($request->hasFile('upload_payment_record_image')) {
            
            $image = $request->file('upload_payment_record_image');
            $order_transaction['payment_image'] = 'branch/sale/transaction/'.time().'_'.$image->getClientOriginalName();
            $image->storeAs('', $order_transaction['payment_image'], 'public');

        }

        $order_transaction['branch_order_id'] = $branch_order->id;
        $order_transaction['payment_method_id'] = $request->input('payment_method_id');
        $order_transaction['payment_option'] = $request->input('payment_option');
        $order_transaction['payment_method'] = $payment_method->detail->title;
        $order_transaction['payment_amount'] = $request->input('payment_amount');

        BranchOrderTransaction::create($order_transaction);

        $items = json_decode($request->input('order_items'));

        foreach($items as $item) {

            // if($item->type == 'cash_coupon' || $item->type == 'service') 
            // {
            //     $customer_package = DB::table('customer_packages')->where('id', $item->id)->first();
                
            //     if($customer_package) {
            //         $customer_package_update = CustomerPackage::find($item->id);
                
            //         $customer_package_update->time_used = $customer_package->time_used + 1;
                
            //         $customer_package_update->time_remain = $customer_package->time_remain - 1;
                
            //         $customer_package_update->save();    
            //     }
                
            // }

            $order_item['branch_order_id'] = $branch_order->id;
            $order_item['item_id'] = "";    
            $order_item['customer_package_id'] = "";
            $order_item['branch_item_id'] = "";

            if($item->type == 'item') {
                $order_item['branch_item_id'] = $item->id;
            }

            if($item->type == 'cash_coupon' || $item->type == 'service') {
                $order_item['item_id'] = $item->id;    
                $order_item['customer_package_id'] = $item->id;
            }
            
            $order_item['title'] = $item->detail ?? $item->title;
            $order_item['quantity'] = $item->quantity;
            $order_item['unit_price'] = $item->unit_price;
            $order_item['item_type'] = $item->type;
            $order_item['total'] = $item->total;
            $order_item_result = BranchOrderItem::create($order_item);
            
            $commission = $item->total;
            
            if ($commission < 0) {
                $commission = $commission * -1;
            } 
            
            $payable_amount = $payable_amount + $commission;
        }
        
        $hr_user_commission_rate = HrOther::where('key', 'hr_user_commission_rate')->first()->value;
        
        $hr_commission_user['branch_order_id'] = $branch_order->id;
        
        $hr_commission_user['hr_user_id'] = $hr_user_id;
        
        $hr_commission_user['title'] = 'Order #'.$branch_order->id . ' Commission' ;
        
        $hr_commission_user['rate'] = $hr_user_commission_rate;
        
        $hr_commission_user['branch_order_total'] = $payable_amount;
        
        $hr_commission_user['order_date'] = $order_date;
        
        $hr_commission_user['payable_amount'] = ((int)$hr_user_commission_rate / 100) * doubleval($payable_amount);
        
        $hr_commission_user['status'] = 1;
        
        HrCommissionUser::create($hr_commission_user);
        
        $hr_user_commission_level = HrOther::where('key', 'hr_user_commission_level')->first()->value;
        
        $hr_user_commission_team = json_decode($hr_user_commission_level);

        $superior_id = $hr_user_id;
        
        $override_commission_items = ItemOverrideCommission::all();
        
        foreach($items as $item) {
            
            if($item->type == 'cash_coupon' || $item->type == 'service') {
                
                foreach($override_commission_items as $override_commission_item) {
                    
                    if($override_commission_item->item_id == $item->id) {
                        
                        foreach($hr_user_commission_team as $parent) {

                            $superior_id = $this->hr_user_parent($superior_id);

                            if($superior_id != null && $superior_id > 0) {
                                $hr_commission_team['branch_order_id'] = $branch_order->id;
                                $hr_commission_team['hr_user_id'] = $superior_id;
                                $hr_commission_team['title'] = 'Order #'.$branch_order->id . ' Commission' ;
                                $hr_commission_team['rate'] = $parent->rate;
                                $hr_commission_team['branch_order_total'] = $payable_amount;
                                $hr_commission_team['payable_amount'] = ((int)$parent->rate / 100) * doubleval($payable_amount);
                                $hr_commission_team['order_date'] = $order_date;
                                $hr_commission_team['status'] = 1;
                                HrCommissionTeam::create($hr_commission_team);    
                            }

                        }
                    }
                }

            }
        }

        return response()->json([
            'message' => 'success',
            'data'      => $data,
            'override_commission_items' => $override_commission_items
        ]);

    }

    public function edit(string $uniqid)
    {
        
        $order = BranchOrder::with(['items', 'transactions', 'customer', 'hr_branch_order_link'])
                                ->where('uniqid', $uniqid)
                                ->where('cooperation_store_id', session('store_id'))
                                ->first();
        
        $payment_methods = PaymentMethod::with(['detail'])->where('status', '1')->orderBy('sort', 'ASC')->get();
        
        $items = BranchItem::where('cooperation_store_id', session('store_id'))->where('status', '1')->get();
        
        $order_statuses = OrderStatus::with(['detail'])->where('status', 1)->orderBy('sort', 'ASC')->get();
        
        $customers = Customer::with(['packages'])->whereIn('id', Appointment::select('customer_id'))->get();
        
        if(HrBranchOrderLink::where('branch_order_id', $order->id)->exists()) {
            $customers = Customer::with(['packages'])->where('id', $order->customer_id)->get();
        }
        
        $branch_customers = BranchCustomer::where('cooperation_store_id', session('store_id'))->where('status', 1)->get();
        
        // $custom_customers = BranchCustomer::where('status', 1)->where('cooperation_store_id', session('store_id'))->get();
        
        return response()->json([
            'order'             => $order,
            'payment_methods'   => $payment_methods,
            'items'             => $items,
            'customers'         => $customers,
            // 'custom_customers'  => $custom_customers,
            'branch_customers'  => $branch_customers,
            'order_statuses'    => $order_statuses,
            'file_path'         => asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/')
        ]);

    }

    public function update(Request $request, string $uniqid)
    {
        
        $order_date = $request->input('order_date');
        
        $data['cooperation_store_id'] = session('store_id');
        $data['order_date'] = $order_date;
        $data['customer_type'] = $request->input('customer_type');
        
        $branch_order = BranchOrder::where('uniqid', $uniqid)->first();
        
        $id = $branch_order->id;
        
        $data['customer_id'] = "";
        $data['branch_customer_id'] = "";
        $hr_user_id = "";
        $payable_amount = 0;
        
        $hr_branch_order_link = HrBranchOrderLink::where('branch_order_id', $id)->first();
        
        if($hr_branch_order_link != null) {
            $hr_user_id = $hr_branch_order_link->hr_user_id;
        }
        
        $appointment = Appointment::where('id', $request->input('appointment_id'))->first();
        
        if($request->input('customer_type') == 'appointment_customer') {
            
            $data['customer_id'] = $request->input('customer_id');
            
            $customer = Customer::where('id', $request->input('customer_id'))->first();
            
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
        }
        
        if($request->input('customer_type') == 'branch_customer') {
            
            $branch_customer_id = $request->input('order_customer');
            
            $customer = BranchCustomer::where('id', $branch_customer_id)->first();
            
            $data['branch_customer_id'] = $branch_customer_id;
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
        }
        
        if($request->input('customer_type') == 'custom_customer') {
            $customer = json_decode($request->input('order_custom_customer'));
            
            $data['name'] = $customer->name;
            $data['telephone'] = $customer->telephone;
            $data['email'] = $customer->email;
            $data['country_code'] = $customer->country_code;
            
            $data['customer_type'] = 'branch_customer';
            
            $branch_customer['cooperation_store_id'] = session('store_id');
            $branch_customer['name'] = $customer->name;
            $branch_customer['telephone'] = $customer->telephone;
            $branch_customer['email'] = $customer->email;
            $branch_customer['country_code'] = $customer->country_code;
            
            $new_branch_customer = BranchCustomer::create($branch_customer);
            
            $data['branch_customer_id'] = $new_branch_customer->id;
        }
        
        $data['comment'] = $request->input('comment') ?? "";
        
        $data['total'] = $request->input('grand_total');
        
        $data['status_id'] = $request->input('order_status_id');

        $status = OrderStatus::with(['detail'])->where('id', $request->input('order_status_id'))->first();
        
        $data['status'] = $status->detail->title ?? "";
        
        $branch_order->update($data);
        
        // if($hr_branch_order_link != "") {
        //     $hr_appointment_link = HrAppointmentLink::where('appointment_id', $appointment_id)->first();
        //     if($hr_appointment_link) {
        //         HrBranchOrderLink::where('branch_order_id', $id)->delete();
                
        //         $hr_branch_order_link['branch_order_id'] = $branch_order->id;
        //         $hr_branch_order_link['hr_user_id'] = $hr_appointment_link->hr_user_id;
        //         $hr_user_id = $hr_appointment_link->hr_user_id;
        //         $hr_branch_order_link['appointment_id'] = $appointment_id;
                
        //         HrBranchOrderLink::create($hr_branch_order_link);    
        //     }
        // }
        
        if($request->input('payment_method_id')) {
            $payment_method = PaymentMethod::with(['detail'])->where('id', $request->input('payment_method_id'))->first();

            $order_transaction['branch_order_id'] = $id;
            $order_transaction['payment_method_id'] = $request->input('payment_method_id');
            $order_transaction['payment_option'] = $request->input('payment_option');
            $order_transaction['payment_method'] = $payment_method->detail->title;
            $order_transaction['payment_amount'] = $request->input('payment_amount');
            
            $order_transaction['receipt_image'] = "";
            if($request->hasFile('upload_receipt_image')) {
                $image = $request->file('upload_receipt_image');
                $order_transaction['receipt_image'] = 'branch/sale/transaction/'.time().'_'.$image->getClientOriginalName();
                $image->storeAs('', $order_transaction['receipt_image'], 'public');
            }
        
            $order_transaction['payment_image'] = "";
        
            if($request->hasFile('upload_payment_record_image')) {
                $image = $request->file('upload_payment_record_image');
                $order_transaction['payment_image'] = 'branch/sale/transaction/'.time().'_'.$image->getClientOriginalName();
                $image->storeAs('', $order_transaction['payment_image'], 'public');
            }

            BranchOrderTransaction::create($order_transaction);    
        }
        
        BranchOrderItem::where('branch_order_id', $id)->delete();
        
        $items = json_decode($request->input('order_items'));

        foreach($items as $item) {

            if($item->type == 'cash_coupon' || $item->type == 'service') 
            {
                $customer_package = DB::table('customer_packages')->where('id', $item->id)->first();
                
                if($customer_package) {
                    $customer_package_update = CustomerPackage::find($item->id);
                
                    $customer_package_update->time_used = $customer_package->time_used + 1;
                    $customer_package_update->time_remain = $customer_package->time_remain - 1;
                
                    $customer_package_update->save();    
                }
                
                
            }
            
            $order_item['branch_order_id'] = $id;
            $order_item['item_id'] = "";    
            $order_item['customer_package_id'] = "";
            $order_item['branch_item_id'] = "";
            
            if($item->type == 'item') {
                $order_item['branch_item_id'] = $item->id;
            }
            
            if($item->type == 'cash_coupon' || $item->type == 'service') {
                $order_item['item_id'] = $item->id;    
                $order_item['customer_package_id'] = $item->id;
            }
            
            $order_item['title'] = $item->detail ?? $item->title;
            $order_item['quantity'] = $item->quantity;
            $order_item['unit_price'] = $item->unit_price;
            $order_item['item_type'] = $item->type;
            $order_item['total'] = $item->total;
            $order_item_result = BranchOrderItem::create($order_item);
            
            $commission = $item->total;
            
            if ($commission < 0) {
                $commission = $commission * -1;
            } 
            
            $payable_amount = $payable_amount + $commission;
            
        }
        
        
        // Hr User Commission
        HrCommissionUser::where('branch_order_id', $id)->delete(); // Delete previous comission
        
        if($hr_user_id > 0) {
            $hr_user_commission_rate = HrOther::where('key', 'hr_user_commission_rate')->first()->value;
            $hr_commission_user['branch_order_id'] = $id;
            $hr_commission_user['hr_user_id'] = $hr_user_id ?? "";
            $hr_commission_user['title'] = 'Order #'.$branch_order->id . ' Commission' ;
            $hr_commission_user['rate'] = $hr_user_commission_rate;
            $hr_commission_user['branch_order_total'] = $payable_amount;
            $hr_commission_user['payable_amount'] = ((int)$hr_user_commission_rate / 100) * doubleval($payable_amount);
            $hr_commission_user['status'] = 1;
            HrCommissionUser::create($hr_commission_user);
        
            $hr_user_commission_level = HrOther::where('key', 'hr_user_commission_level')->first()->value;
            $hr_user_commission_team = json_decode($hr_user_commission_level);
        
            HrCommissionTeam::where('branch_order_id', $id)->delete();
        
            $superior_id = $hr_user_id;
        
            foreach($hr_user_commission_team as $parent) {
            
                $superior_id = $this->hr_user_parent($superior_id);
                
                if($superior_id > 0) {
                    $hr_commission_team['branch_order_id'] = $id;
                    $hr_commission_team['hr_user_id'] = $superior_id;
                    $hr_commission_team['title'] = 'Order #'.$branch_order->id . ' Commission' ;
                    $hr_commission_team['rate'] = $parent->rate;
                    $hr_commission_team['branch_order_total'] = $payable_amount;
                    $hr_commission_team['payable_amount'] = ((int)$parent->rate / 100) * doubleval($payable_amount);
                    $hr_commission_team['order_date'] = $order_date;
                    $hr_commission_team['status'] = 1;
                    HrCommissionTeam::create($hr_commission_team);    
                }
                
            }    
        }
        

        return response()->json([
            'message' => 'success',
            
        ]);
    }
    
    public function hr_user_parent($hr_user_id) {
        
        $data = HrUser::where('id', $hr_user_id)->first();
        
        if($data != null) {
            return $data->superior_id;    
        }
        
        return null;
    }

}
