<?php

namespace App\Http\Controllers\Branch\Setting;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Contracts\Database\Eloquent\Builder;
use PHPUnit\Event\Telemetry\System;
use App\Models\HrUser;
use App\Models\CooperationStore;
use App\Models\Language;
use Illuminate\Support\Facades\DB;

class ProfileController extends Controller
{

    
   
    public function index()
    {
        
        $store = CooperationStore::where('id', session('store_id'))->where('login_email', session('branch_email'))->first();
        
        $languages = Language::where('status', 1)->get();
        
        return response()->json([
            'store'             => $store,
            'languages'         => $languages
        ]);
        
    }

    public function update(Request $request)
    {

        $cooperation_store = CooperationStore::find(session('store_id'));

        $data['language_id'] = $request->input('language_id');
        $data['name'] = $request->input('name');
        $data['telephone'] = $request->input('telephone');
        
        if($request->input('password')) {
            $data['password'] = Hash::make($request->input('password'));
        } else {
            $data['password'] = $cooperation_store->password;
        }

        $cooperation_store->update($data);

        return response()->json([
            'message' => 'success',
        ]);

    }

}
