<?php

namespace App\Http\Controllers\Branch;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Models\PermissionToUser;

class SettingController extends Controller
{

    public function index()
    {
        $logoImg = Setting::where('key', 'logoImgPreview')->first();
  
        $logo = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/'.$logoImg->value);
        
        $faviconImg = Setting::where('key', 'faviconImgPreview')->first();
        
        $favicon = asset(env('APP_URL').'/'.env('APP_FOLDER').'/storage/app/public/'.$faviconImg->value);
        
        $data = Setting::where('type', '=', 'system')->get();
        

        return response()->json([
            'logo'  => $logo,
            'favicon'    => $favicon,
            'data'  => $data,
        ]);
    }

}
